<?php $__env->startSection('title'); ?>
    System Logs
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagetitle'); ?>
    System Logs
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <h3 class="panel-title">System Logs</h3>
                    </div>

                    <div class="panel-body">
                        <div class="row">

                            
                            <div class="col-sm-3">
                                <h5 class="text-muted">
                                    Log Files
                                    <span class="badge"><?php echo e(count($files)); ?></span>
                                </h5>

                                <div class="list-group" style="max-height: 70vh; overflow-y:auto;">
                                    <?php $__empty_1 = true; $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <a href="<?php echo e(route('system.logs', ['file' => $file])); ?>"
                                           class="list-group-item <?php echo e($file === $activeFile ? 'active' : ''); ?>">
                                            <div class="clearfix">
                                                <span class="pull-left text-truncate"
                                                      style="max-width: 150px; display:inline-block;">
                                                    <?php echo e($file); ?>

                                                </span>
                                                <?php
                                                    $sizeKb = @filesize(storage_path('logs/'.$file)) / 1024;
                                                ?>
                                                <small class="pull-right text-muted">
                                                    <?php if($sizeKb): ?>
                                                        <?php echo e(number_format($sizeKb, 1)); ?> KB
                                                    <?php endif; ?>
                                                </small>
                                            </div>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <p class="text-muted">
                                            No log files found in <code>storage/logs</code>.
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>

                            
                            <div class="col-sm-9">

                                <?php if($activeFile): ?>
                                    <div class="clearfix" style="margin-bottom:10px;">
                                        <div class="pull-left">
                                            <strong>Viewing:</strong> <?php echo e($activeFile); ?> <br>
                                            <?php if($fileSize): ?>
                                                <small class="text-muted">
                                                    Size: <?php echo e(number_format($fileSize / 1024, 1)); ?> KB
                                                </small><br>
                                            <?php endif; ?>

                                            <?php if(!empty($truncated) && $truncated): ?>
                                                <small class="text-warning">
                                                    Showing only the last <?php echo e(number_format($tailBytes / 1024, 1)); ?> KB
                                                    of this file (large log truncated).
                                                </small>
                                            <?php endif; ?>
                                        </div>

                                        <div class="pull-right">
                                            <a href="<?php echo e(route('system.logs', ['file' => $activeFile])); ?>"
                                               class="btn btn-xs btn-default">
                                                Refresh
                                            </a>
                                        </div>
                                    </div>

                                    
                                    <div style="border:1px solid #ddd;
                                                max-height:70vh;
                                                overflow:auto;
                                                background:#111827;
                                                color:#e5e7eb;">
                                        <pre style="margin:0; padding:10px;
                                                    white-space:pre-wrap;
                                                    font-size:12px;
                                                    font-family:Menlo,Monaco,Consolas,'Courier New',monospace;">
<?php echo nl2br(e($content)); ?>

                                        </pre>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted">
                                        Select a log file on the left to view its contents.
                                    </p>
                                <?php endif; ?>

                            </div> 

                        </div> 
                    </div> 
                </div> 
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /app/resources/views/system/logs.blade.php ENDPATH**/ ?>