<!DOCTYPE html>
<html lang="en" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <meta name="x-apple-disable-message-reformatting" />
  <meta name="color-scheme" content="light">
  <meta name="supported-color-schemes" content="light">
  <title><?php echo e($type ?? 'Notification'); ?></title>
  <style>
    .preheader{display:none!important;visibility:hidden;opacity:0;color:transparent;height:0;width:0;overflow:hidden;mso-hide:all;}
    @media only screen and (max-width:600px){
      .container{width:100%!important}
      .px{padding-left:16px!important;padding-right:16px!important}
      .p{padding:16px!important}
      .stack{display:block!important;width:100%!important}
      .btn{width:100%!important;display:block!important}
    }
  </style>
</head>

<body style="margin:0;padding:0;background:#ffffff;-webkit-font-smoothing:antialiased;-webkit-text-size-adjust:none;">
  <?php $getsetvalue = new \App\Models\Setting(); ?>

  <!-- Preheader (optional; hidden) -->
  <div class="preheader"><?php echo e($preheader ?? ''); ?></div>

  <!-- Canvas -->
  <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0" style="background:#ffffff;">
    <tr>
      <td align="center" style="padding:24px 12px;">
        <table role="presentation" width="700" cellpadding="0" cellspacing="0" border="0" class="container" style="width:700px;max-width:700px;">

          <!-- BRAND HEADER (orange) -->
          <tr>
            <td style="padding:0;">
              <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0" style="background:#EE8520;border-radius:8px 8px 0 0;">
                <tr>
                  <td class="px" style="padding:14px 20px;" width="1">
                    <img src="<?php echo e(asset($getsetvalue->getsettingskey('company_logo'))); ?>" width="120" alt="Company Logo"
                         style="display:block;background:#ffffff;padding:4px;border-radius:6px;max-width:120px;height:auto;border:0;">
                  </td>
                  <td class="px" align="left" style="padding:14px 20px;font-family:Arial,Helvetica,sans-serif;">
                    <h3 style="margin:0;color:#ffffff;font-size:19px;line-height:24px;font-weight:700;">
                      <?php echo $type ?? 'Notification'; ?>

                    </h3>
                    <div style="height:4px;line-height:4px;font-size:4px;">&nbsp;</div>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- CARD (white, orange accent) -->
          <tr>
            <td style="padding:0;">
              <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0"
                     style="background:#ffffff;border-bottom:4px solid #EE8520;border-radius:0 0 8px 8px;box-shadow:0 2px 8px rgba(0,0,0,.06);">
                <tr>
                  <td class="px p" style="padding:24px;font-family:Arial,Helvetica,sans-serif;color:#333;">

                    <!-- BODY MESSAGE (your $msg) -->
                    <div style="font-size:15px;line-height:22px;margin-bottom:18px;">
                      <?php echo $msg; ?>

                    </div>

                    <!-- BANNER #1 -->
                    <div style="margin:8px 0 16px 0;">
                      <img src="<?php echo e(asset('assets/img/1.png')); ?>" alt="" width="652" style="display:block;width:100%;max-width:652px;height:auto;border-radius:8px;border:0;outline:0;">
                    </div>

                    <!-- CALL-OUT (3 CTAs) -->
                    <div style="text-align:center;margin:6px 0 16px 0;">
                      <!-- WhatsApp -->
                      <a href="https://wa.me/+2348179470991"
                         class="btn"
                         style="background:#EE8520;border:1px solid #EE8520;border-radius:6px;color:#ffffff;
                                display:inline-block;font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:600;
                                line-height:42px;text-align:center;text-decoration:none;padding:0 18px;min-width:200px;margin:4px 6px;">
                        WhatsApp Banking
                      </a>
                      <!-- USSD -->
                      <a href="tel:*7006*10#"
                         class="btn"
                         style="background:#EE8520;border:1px solid #EE8520;border-radius:6px;color:#ffffff;
                                display:inline-block;font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:600;
                                line-height:42px;text-align:center;text-decoration:none;padding:0 18px;min-width:200px;margin:4px 6px;">
                        *7006*10#
                      </a>
                      <!-- Mobile Banking -->
                      <a href="https://cashmatrix.ng/"
                         class="btn"
                         style="background:#EE8520;border:1px solid #EE8520;border-radius:6px;color:#ffffff;
                                display:inline-block;font-family:Arial,Helvetica,sans-serif;font-size:14px;font-weight:600;
                                line-height:42px;text-align:center;text-decoration:none;padding:0 18px;min-width:200px;margin:4px 6px;">
                        Mobile Banking
                      </a>
                    </div>

                    <!-- BANNER #2 -->
                    <div style="margin:8px 0 8px 0;">
                      <img src="<?php echo e(asset('assets/img/2.png')); ?>" alt="" width="652" style="display:block;width:100%;max-width:652px;height:auto;border-radius:8px;border:0;outline:0;">
                    </div>

                    <!-- CONTACT INFO -->
                    <div style="height:1px;background:#e5e7eb;margin:18px 0;"></div>
                    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
                      <tr>
                        <td align="left" style="font-family:Arial,Helvetica,sans-serif;">
                          <h5 style="margin:0 0 6px 0;font-size:15px;color:#111;">Contact Info:</h5>
                          <p style="margin:0;font-size:14px;color:#374151;line-height:22px;">
                            Phone: <strong><a href="tel:+2347046488013" style="color:#EE8520;text-decoration:none;">+234 (0)704 648 8013</a></strong><br/>
                            Email: <strong><a href="mailto:support@assetmatrixmfb.com" style="color:#EE8520;text-decoration:none;">support@assetmatrixmfb.com</a></strong>
                          </p>
                        </td>
                      </tr>
                    </table>

                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- FOOTER LINKS -->
          <tr>
            <td align="center" style="padding:16px 12px;font-family:Arial,Helvetica,sans-serif;">
              <p style="margin:0;font-size:12px;color:#999;">
                <a href="https://assetmatrixmfb.com/user-agreement" style="color:#EE8520;text-decoration:none;">Terms and Conditions</a>
                &nbsp;|&nbsp;
                <a href="https://assetmatrixmfb.com/data-consent" style="color:#EE8520;text-decoration:none;">Privacy Policy</a>
              </p>
              <p style="margin-top:6px;font-size:12px;color:#999;">
                © <?php echo e(date('Y')); ?> <?php echo e(ucwords($getsetvalue->getsettingskey('company_name') ?: 'AssetMatrix Microfinance Bank')); ?>. All rights reserved.
              </p>
            </td>
          </tr>

        </table>
      </td>
    </tr>
  </table>
</body>
</html>
<?php /**PATH /home/victor/Documents/GGT/assetmatrix-cba/resources/views/mails/app-mail.blade.php ENDPATH**/ ?>