<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\RegisterController;
use App\Http\Controllers\Api\CustomersController;
use App\Http\Controllers\Api\TransactionController;
use App\Http\Controllers\Api\VtpassController;
use App\Http\Controllers\Api\GiftbillController;
use App\Http\Controllers\Api\MonnifyController;
use App\Http\Controllers\Api\NibbspayController;
use App\Http\Controllers\Api\WirelessController;
use App\Http\Controllers\Api\NibbsController;
use App\Http\Controllers\Api\WhatsappController;

/*
|--------------------------------------------------------------------------
| API ROUTES
|--------------------------------------------------------------------------
| - Public routes (no auth)
| - Protected customer routes (Sanctum)
| - Internal bank routes (IP restricted)
|--------------------------------------------------------------------------
*/


/*
|--------------------------------------------------------------------------
| PUBLIC ROUTES (NO AUTH)
|--------------------------------------------------------------------------
*/

Route::middleware(['log.route'])->group(function () {

    // AUTH
    Route::post('/customers/login', [LoginController::class, 'login']);
    Route::post('/customers/register', [RegisterController::class, 'register']);
    Route::post('/customers/existregister', [RegisterController::class, 'existingAccount']);

    // OTP
    Route::post('/customers/confirm-otp', [CustomersController::class, 'confirm_otp']);
    Route::post('/customers/verify-otp', [CustomersController::class, 'verify_otp']);
    Route::post('/customers/resend-otp', [CustomersController::class, 'resend_otp']);

    // PHONE OTP
    Route::post('/customers/phone-otp', [RegisterController::class, 'sendPhoneOtp']);
    Route::post('/customers/phone-verify', [RegisterController::class, 'verifyPhoneOtp']);
    Route::post('/customers/phone/resend-otp', [RegisterController::class, 'resendPhoneOtp']);

    // PASSWORD
    Route::post('/customers/forgot-password', [CustomersController::class, 'forgetpassword']);
    Route::post('/customers/reset-password', [CustomersController::class, 'reset_password']);

    // BVN
    Route::post('/customers/bvn', [CustomersController::class, 'verifyBvn']);
    Route::post('/bvn', [RegisterController::class, 'bvn']);
    Route::post('/bvn/verification', [TransactionController::class, 'bvn_verify']);

    // WEBHOOK
    Route::post('/transactions/webhook/notification-payload', [TransactionController::class, 'save_notification_payload']);

    // WHATSAPP
    Route::post('/whatsapp', [WhatsappController::class, 'whatsapp_index']);
});



/*
|--------------------------------------------------------------------------
| CUSTOMER PROTECTED ROUTES
|--------------------------------------------------------------------------
| Sanctum + customer ability
|--------------------------------------------------------------------------
*/

Route::middleware([
    'auth:sanctum',
    'abilities:customer',
    'log.route'
])->prefix('customers')->group(function () {

    Route::post('/logout', [LoginController::class, 'logout_customer']);

    Route::post('/change-password', [CustomersController::class, 'change_password']);
    Route::post('/change-pin', [CustomersController::class, 'reset_pin']);

    Route::post('/upload-file', [CustomersController::class, 'uploadFile']);

    Route::get('/get-details', [CustomersController::class, 'get_customers_details']);
    Route::post('/update-profile', [CustomersController::class, 'update_profile']);

    Route::get('/get-balance', [CustomersController::class, 'getBalance']);
    Route::get('/get-beneficiary', [CustomersController::class, 'getbeneficiary']);

    Route::get('/get-transactions', [CustomersController::class, 'getTransactions']);

    // DEVICE LINK
    Route::post('/send/linkdevice-otp', [CustomersController::class, 'sendLinkDeviceOtp']);
    Route::post('/resend/linkdevice-otp', [CustomersController::class, 'resendLinkDeviceOtp']);
    Route::post('/verify/linkdevice-otp', [CustomersController::class, 'verifyLinkDeviceOTP']);
});



/*
|--------------------------------------------------------------------------
| TRANSACTIONS (CUSTOMER AUTH)
|--------------------------------------------------------------------------
*/

Route::middleware([
    'auth:sanctum',
    'abilities:customer',
    'log.route'
])->prefix('transactions')->group(function () {

    // VTU
    Route::post('/verify-smartcard', [VtpassController::class, 'verify_smartcard_number']);
    Route::get('/get-subcriptions', [VtpassController::class, 'get_subcriptions']);
    Route::post('/pay-cabletv-subcription', [VtpassController::class, 'pay_cable_tv']);

    Route::post('/buy-airtime', [VtpassController::class, 'buy_airtime']);
    Route::get('/get-databundles/{networktype}', [VtpassController::class, 'getdatabundles']);
    Route::post('/buy-data-bundle', [VtpassController::class, 'buy_data_bundle']);

    Route::post('/verify-meter', [VtpassController::class, 'verify_meter_number']);
    Route::post('/pay-electricty', [VtpassController::class, 'pay_electricty']);

    // BETTING
    Route::get('/betting-providers', [GiftbillController::class, 'get_betting_companies']);
    Route::post('/verify-betting-account', [GiftbillController::class, 'verify_betting_account']);
    Route::post('/top-betting-account', [GiftbillController::class, 'topup_betting']);

    // TRANSACTION HISTORY
    Route::get('/get-transaction-statement', [TransactionController::class, 'get_transactionStatement']);
    Route::get('/get-transaction-history', [TransactionController::class, 'get_transactionHistory']);
    Route::get('/single-transaction/{ref}', [TransactionController::class, 'single_transaction']);
    Route::get('/transaction_receipt/{ref}', [TransactionController::class, 'transaction_recipt']);

    // WALLET
    Route::post('/verify-wallet-account', [TransactionController::class, 'verifyWalletAccount']);
    Route::post('/wallet/initiate-transaction', [TransactionController::class, 'initiateTransaction']);
    Route::post('/wallet-transfer', [TransactionController::class, 'transferToWalletAccount']);

    Route::get('/get-banks', [TransactionController::class, 'getAllBanks']);
});

https://github.com/victorikhianosen/dwmfb-internetbanking.git


/*
|--------------------------------------------------------------------------
| INTERNAL BANK / NIBSS ROUTES (IP RESTRICTED)
|--------------------------------------------------------------------------
*/

// Route::middleware('checkip')->prefix('accounts')->group(function () {

//     Route::get('/lookup/{account_number}', [NibbsController::class, 'lookupAccount']);
//     Route::post('/block', [NibbsController::class, 'blockUserAccount']);
//     Route::post('/unblock', [NibbsController::class, 'unblockUserAccount']);
//     Route::post('/credit-user', [NibbsController::class, 'creditUser']);
//     Route::post('/debit-user', [NibbsController::class, 'debitUser']);
//     Route::post('/balance', [NibbsController::class, 'getAccountBalance']);

//     Route::post('/amount/block', [NibbsController::class, 'lienAccount']);
//     Route::post('/amount/unblock', [NibbsController::class, 'unlienAccount']);

//     Route::post('/advice', [NibbsController::class, 'accountMandate']);
//     Route::post('/advice/debit-user', [NibbsController::class, 'directDebitMandate']);
//     Route::post('/advice/credit-user', [NibbsController::class, 'creditUser']);

//     Route::post('/funds-transfer-advice/credit-user', [NibbsController::class, 'reverseFundsTransferCredit']);
//     Route::post('/funds-transfer-advice/debit-user', [NibbsController::class, 'reverseFundsTransferDebit']);

//     Route::post('/fi', [NibbsController::class, 'addNewBanks']);
// });
