@extends('layout.app')
@section('title')
    Ipwhitelisting
@endsection
@section('pagetitle')
Ipwhitelisting
@endsection
@section('content')
  <div class="container">
    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align: end">
                            <a href="#" onclick="createip()" class="btn btn-default"><span class="menu-icon"> <i class="fa fa-plus"></i> </span>Add Ip Address</a>
                         </div>
                      </div>
                  <div class="panel-body">
                   
                    <div class="row">
                        <div class="col-md-12 col-lg-12 col-sm-12">
                      @include('includes.success')
                        </div>
                        </div>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed table-hover" id="acoff">
                            <thead>
                                <tr>
                                    <th>Sn</th>
                                    <th>Organisation</th>
                                    <th>Ip Address</th>
                                    <th>Created At</th>
                                    <th></th>
                                </tr>
                            </thead>    
                            <tbody>
                                <?php $i=0;?>
                                @foreach ($whitlists as $item)
                                <tr>
                                    <td>{{$i+1}}</td>
                                    
                                    <td>{{ucwords($item->company_name)}}</td>
                                    <td>{{$item->ip_address}}</td>
                                    <td>{{date("d-M-Y H:ia",strtotime($item->created_at))}}</td>
                                    <td>
                                        <a href="#" onclick="editip('{{$item->id}}','{{$item->company_name}}','{{$item->ip_address}}')" class="btn vd_btn vd_bg-twitter btn-sm">Edit</a>
                                        <a href="{{route('delete.ipaddress',['id' => $item->id])}}" onclick="return confirm('Are u sure u want to delete these record')" class="btn vd_btn vd_bg-red btn-sm">Delete</a>
                                    </td>
                                </tr>
                                <?php $i++?>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                  </div>
                </div>
                <!-- Panel Widget --> 
              </div>
              <!-- col-md-12 --> 
            </div>
            <!-- row -->
  </div>

  <!-- Modal -->
 <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header vd_bg-blue vd_white">
          <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
          <h4 class="modal-title" id="myModalLabel"></h4>
        </div>
        <div class="modal-body"> 
          <form class="form-horizontal" action="{{route('store.ipaddress')}}" method="post" id="ipaddr">
            @csrf
            <div class="form-group">
              <label class="col-sm-3 control-label">Company Name</label>
              <div class="col-sm-8 controls">
                <input class="width-70" type="text" name="company_name" id="cmname" value="{{old('company_name')}}" autocomplete="off" placeholder="Company Name">
              </div>
              </div>
            
            <div class="form-group">
              <label class="col-sm-3 control-label">IP Address</label>
              <div class="col-sm-8 controls">
                <input class="width-70" type="text" pattern="^(([0-9a-fA-F]{1}|[1-9a-fA-F]{1}[0-9a-fA-F]{1,3}):){7}([0-9a-fA-F]{1}|[1-9a-fA-F]{1}[0-9a-fA-F]{1,3})$" minlength="7" maxlength="15" size="15" name="ip_address" id="ipa" value="{{old('ip_address')}}" autocomplete="off" placeholder="IP Address">
              </div>
              </div>

            <input type="hidden" name="savetyp" id="stype" value="">
            <input type="hidden" name="ipid" id="pid" value="">
          </form>
        
        </div>
        <div class="modal-footer background-login">
          <button type="button" class="btn vd_btn vd_bg-grey" data-dismiss="modal">Close</button>
          <button type="button" class="btn vd_btn vd_bg-green" id="cmbtnssubmit" onclick="document.getElementById('ipaddr').submit()">Save Record</button>
        </div>
      </div>
      <!-- /.modal-content --> 
    </div>
    <!-- /.modal-dialog --> 
  </div>
  <!-- /.modal --> 
@endsection
@section('scripts')

<script>
    function createip(){
        $("#myModal").modal('show');
        $("#myModalLabel").text('Add IP Address');
        $("#stype").val('create');
      }

    function editip(id,nm,ip){
        $("#myModal").modal('show');
        $("#myModalLabel").text('Update IP Address');
        $("#stype").val('update');
        $("#cmname").val(nm);
        $("#ipa").val(ip);
        $("#pid").val(id);
        
      }
  </script>
  
    <script type="text/javascript">
  $(document).ready(function(){
    $("#acoff").dataTable({'pageLength':25,
    'dom': 'Bfrtip',
      buttons: [ 'copy', 'csv', 'print','pdf']
  });
  });
</script>
@endsection
