@extends('layout.app')

@section('title', 'Target Savings Products')
@section('pagetitle', 'Target Savings Products')

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align:end">
                            <a href="{{ route('targetsavings.product.create') }}" class="btn btn-default">
                                <span class="menu-icon"><i class="fa fa-plus"></i></span> Add Savings Product
                            </a>
                        </div>
                    </div>

                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                @include('includes.errors')
                                @include('includes.success')
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-condensed table-hover" id="acoff">
                                <thead>
                                    <tr>
                                        <th>Sn</th>
                                        <th>Product Name</th>
                                        <th>Product No</th>
                                        <th>Minimum Target Deposit</th>
                                        <th>Interest Rate Per Annum (%)</th>
                                        <th>Minimum Hold Days</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($products as $item)
                                        <tr>
                                            {{-- Serial number that keeps counting across pages --}}
                                            <td>{{ $products->firstItem() + $loop->index }}</td>

                                            {{-- Eloquent objects: use -> not [''] --}}
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->product_code }}</td>
                                            <td>{{ number_format($item->minimum_target_deposit, 2) }}</td>
                                            <td>{{ number_format($item->interest_rate, 2) }}</td>
                                            <td>{{ $item->min_hold_days ?? $item->minimum_hold_days }}</td>
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-default dropdown-toggle"
                                                        data-toggle="dropdown">
                                                        Action <i class="fa fa-caret-down prepend-icon"></i>
                                                    </button>
                                                    <ul class="dropdown-menu" role="menu">
                                                        <li><a
                                                                href="{{ route('targetsavings.product.edit', $item['id']) }}">Edit</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">No products found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>


                        <div
                            style="display:flex; justify-content:space-between; align-items:center; width:100%; margin-top:20px; margin-bottom:20px; padding:0 20px;">
                            <div style="color:#6c757d; font-size:14px;">
                                Showing {{ $products->firstItem() }} to {{ $products->lastItem() }} of
                                {{ $products->total() }} entries
                            </div>
                            <div style="display:flex; justify-content:center; align-items:center;">
                                {{ $products->withQueryString()->links() }}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
