@extends('layout.app')

@section('title', 'Manage Target')
@section('pagetitle', 'Manage Target Savings')

@section('content')
<div class="container">
  <div class="row" id="advanced-input">
    <div class="col-md-12">
      <div class="panel widget">

        {{-- Top bar: ONLY the Add button at top-right --}}
        <div class="panel-heading">
          <div style="display:flex; justify-content:end; align-items:center;">
            <a href="{{ route('targetsavings.create') }}" class="btn btn-default">
              <span class="menu-icon"><i class="fa fa-plus"></i></span> Add Target Savings
            </a>
          </div>
        </div>

        <div class="panel-body">

          {{-- Toolbar row: LEFT = CSV/Copy/Print (export route), RIGHT = Search --}}
          <div style="display:flex; justify-content:space-between; align-items:center; gap:12px; margin-bottom:15px; flex-wrap:wrap;">

            {{-- LEFT: Export buttons (use named route + ?type=... and preserve current filters) --}}
            @php
              $qsBase = request()->all(); // keep q, status, etc.
            @endphp
            <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
              <a href="{{ route('targetsavings.export') }}?{{ http_build_query(array_filter(array_merge($qsBase, ['type' => 'excel']))) }}"
                 class="btn btn-default">
                <i class="fa fa-file-excel-o"></i> Excel
              </a>

              <a href="{{ route('targetsavings.export') }}?{{ http_build_query(array_filter(array_merge($qsBase, ['type' => 'copy']))) }}"
                 class="btn btn-default" target="_blank" rel="noopener">
                <i class="fa fa-clipboard"></i> Copy
              </a>

              <a href="{{ route('targetsavings.export') }}?{{ http_build_query(array_filter(array_merge($qsBase, ['type' => 'print']))) }}"
                 class="btn btn-default" target="_blank" rel="noopener">
                <i class="fa fa-print"></i> Print
              </a>
            </div>

            {{-- RIGHT: Search form (inline, one line) --}}
            <form method="GET" action="{{ url()->current() }}" style="display:flex; align-items:center; gap:8px; flex-wrap:nowrap;">
              <input
                type="text"
                name="q"
                value="{{ old('q', request('q', '')) }}"
                placeholder="Search by code, name, account, frequency..."
                class="form-control"
                style="width:260px;"
              />
              @if(request()->has('status'))
                <input type="hidden" name="status" value="{{ request('status') }}">
              @endif
              <button type="submit" class="btn btn-primary" style="white-space:nowrap;">Search</button>
              <a href="{{ url()->current() }}" class="btn btn-default" style="white-space:nowrap;">Reset</a>
            </form>
          </div>

          {{-- Feedback messages --}}
          <div class="row">
            <div class="col-md-12 col-lg-12 col-sm-12">
              @include('includes.errors')
              @include('includes.success')
            </div>
          </div>

          {{-- Table --}}
          <div class="table-responsive">
            <table class="table table-striped table-sm table-bordered table-condensed table-hover">
              <thead>
                <tr>
                  <th>Sn</th>
                  <th>Code</th>
                  <th>Name</th>
                  <th>Account No</th>
                  <th>Target Amount</th>
                  <th>Save Amount</th>
                  <th>Target Name</th>
                  <th>Frequency</th>
                  <th>Start Date</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                @php $i = $targets->firstItem(); @endphp
                @forelse ($targets as $item)
                  @php
                    $fn = optional($item->customer)->first_name;
                    $ln = optional($item->customer)->last_name;
                    $custId = optional($item->customer)->id;
                    $custName = ucwords(trim(($ln ?? '').' '.($fn ?? ''))) ?: 'N/A';

                    $badge = 'vd_bg-black';
                    $label = ucfirst((string)$item->status);
                    if ($item->status === 'pending')  { $badge = 'vd_bg-yellow'; $label = 'Pending Approval'; }
                    if (in_array($item->status, ['approved','active'], true)) { $badge = 'vd_bg-green';  $label = 'Active'; }
                    if (in_array($item->status, ['declined','rejected','terminate'], true)) { $badge = 'vd_bg-red'; }
                    if (in_array($item->status, ['closed','close'], true)) { $badge = 'vd_bg-black'; }
                  @endphp

                  <tr id="d{{ $item->id }}">
                    <td>{{ $i }}</td>
                    <td>{{ $item->code }}</td>
                    <td>
                      @if($custId)
                        <a href="{{ route('customer.view', ['id' => $custId]) }}">{{ $custName }}</a>
                      @else
                        {{ $custName }}
                      @endif
                    </td>
                    <td>
                      @if($custId)
                        <a href="{{ route('saving.transaction.details', ['id' => $custId]) }}" title="view statement">
                          {{ $item->account_number }}
                        </a>
                      @else
                        {{ $item->account_number }}
                      @endif
                    </td>
                    <td>{{ number_format((float) $item->target_amount, 2) }}</td>
                    <td>{{ number_format((float) $item->auto_save_amount, 2) }}</td>
                    <td><span class="text-info">{{ $item->savings_plan_name }}</span></td>
                    <td>{{ ucfirst((string) $item->frequency) }}</td>
                    <td>{{ $item->auto_save_start_date ? \Carbon\Carbon::parse($item->auto_save_start_date)->format('d-m-Y') : '—' }}</td>
                    <td><span class="badge {{ $badge }}">{{ $label }}</span></td>
                    <td>
                      <div class="btn-group">
                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                          Action <i class="fa fa-caret-down prepend-icon"></i>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                          <li><a href="{{ route('targetsavings.show', $item->id) }}">Details</a></li>
                          @if($item->status === 'pending')
                            <li><a href="{{ route('targetsavings.edit', $item->id) }}">Edit</a></li>
                          @endif
                        </ul>
                      </div>
                    </td>
                  </tr>
                  @php $i++; @endphp
                @empty
                  <tr><td colspan="11" class="text-center">No target savings found.</td></tr>
                @endforelse
              </tbody>
            </table>
          </div>

          {{-- Pagination --}}
          <div style="display:flex; justify-content:space-between; align-items:center; width:100%; margin-top:20px; margin-bottom:20px; padding:0 20px;">
            <div style="color:#6c757d; font-size:14px;">
              Showing {{ $targets->firstItem() }} to {{ $targets->lastItem() }} of {{ $targets->total() }} entries
            </div>
            <div style="display:flex; justify-content:center; align-items:center;">
              {{ $targets->withQueryString()->links() }}
            </div>
          </div>

        </div> {{-- /panel-body --}}
      </div> {{-- /panel --}}
    </div>
  </div>
</div>
@endsection
