<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Print - Target Savings</title>
  <style>
    body { font-family: Arial, Helvetica, sans-serif; color:#111; margin:16px; }
    h2 { margin: 0 0 12px; }
    .meta { color:#666; font-size:12px; margin-bottom:16px; }
    table { width: 100%; border-collapse: collapse; }
    th, td { border: 1px solid #ddd; padding: 6px 8px; font-size: 12px; }
    th { background: #f5f5f7; text-align: left; }
    .right { text-align: right; }
    @media print {
      .noprint { display: none !important; }
      th, td { font-size: 11px; }
    }
    .badge { display:inline-block; padding:2px 6px; border-radius:4px; font-size:11px; }
    .green { background:#e6f4ea; color:#137333; }
    .red   { background:#fbeaea; color:#a0201a; }
    .yellow{ background:#fff6e5; color:#b26b00; }
    .black { background:#eee; color:#111; }
  </style>
</head>
<body>
  <div class="noprint" style="display:flex; justify-content:flex-end; gap:8px;">
    <a href="{{ url()->previous() }}" style="padding:6px 10px; border:1px solid #ccc; border-radius:6px; text-decoration:none;">Back</a>
  </div>

  <h2>Target Savings (Print)</h2>
  <div class="meta">
    @if(!empty($q)) <strong>Search:</strong> {{ $q }} &nbsp;&nbsp; @endif
    <strong>Generated:</strong> {{ now()->format('d M, Y H:i') }}
  </div>

  <table>
    <thead>
      <tr>
        <th>Code</th>
        <th>Name</th>
        <th>Account No</th>
        <th class="right">Target Amount</th>
        <th class="right">Save Amount</th>
        <th>Target Name</th>
        <th>Frequency</th>
        <th>Start Date</th>
        <th>Status</th>
      </tr>
    </thead>
    <tbody>
      @foreach($rows as $item)
        @php
          $fn = $item->c_first_name ?? '';
          $ln = $item->c_last_name ?? '';
          $custName = ucwords(trim(($ln.' '.$fn))) ?: 'N/A';
          $badge = 'black';
          if ($item->status === 'pending')  $badge = 'yellow';
          if (in_array($item->status, ['approved','active'])) $badge = 'green';
          if (in_array($item->status, ['declined','rejected','terminate'])) $badge = 'red';
        @endphp
        <tr>
          <td>{{ $item->code }}</td>
          <td>{{ $custName }}</td>
          <td>{{ $item->account_number }}</td>
          <td class="right">{{ number_format((float) $item->target_amount, 2) }}</td>
          <td class="right">{{ number_format((float) $item->auto_save_amount, 2) }}</td>
          <td>{{ $item->savings_plan_name }}</td>
          <td>{{ ucfirst((string)$item->frequency) }}</td>
          <td>{{ $item->auto_save_start_date ? \Carbon\Carbon::parse($item->auto_save_start_date)->format('d-m-Y') : '—' }}</td>
          <td><span class="badge {{ $badge }}">{{ ucfirst((string)$item->status) }}</span></td>
        </tr>
      @endforeach
    </tbody>
  </table>
</body>
</html>
