@extends('layout.app')

@section('title', 'Copy Target Savings')
@section('pagetitle', 'Copy Target Savings')

@section('content')
<div class="container" style="max-width:960px;">
  <div class="panel widget">
    <div class="panel-heading" style="display:flex; justify-content:space-between; align-items:center;">
      <h4 style="margin:0;">Copy (Plain Text)</h4>
      <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
    </div>

    <div class="panel-body">
      <p class="text-muted" style="margin-bottom:8px;">Select all the text below and copy.</p>
      <textarea readonly style="width:100%; min-height:360px; font-family:monospace; font-size:12px; white-space:pre;">
Code	Name	Account No	Target Amount	Save Amount	Target Name	Frequency	Start Date	Status
@foreach($rows as $r)
{{ $r->code }}	{{ ucwords(trim(($r->c_last_name ?? '').' '.($r->c_first_name ?? ''))) ?: 'N/A' }}	{{ $r->account_number }}	{{ number_format((float)$r->target_amount,2,'.','') }}	{{ number_format((float)$r->auto_save_amount,2,'.','') }}	{{ $r->savings_plan_name }}	{{ ucfirst((string)$r->frequency) }}	{{ $r->auto_save_start_date }}	{{ ucfirst((string)$r->status) }}
@endforeach
      </textarea>
    </div>
  </div>
</div>
@endsection
