@extends('layout.app')
@section('title', 'Edit Target Savings')
@section('pagetitle', 'Edit Target Savings')

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align:end">
                            <a href="{{ route('targetsavings.manage') }}" class="btn btn-danger">
                                <span class="menu-icon"><i class="fa fa-angle-left"></i></span> Back
                            </a>
                        </div>
                    </div>

                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                @include('includes.errors')
                                @include('includes.success')
                            </div>
                        </div>

                        <form class="form-horizontal" action="{{ route('targetsavings.update', ['id' => $target->id]) }}"
                            method="post" role="form" id="submitfd" enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="target_savings_products_id" value="{{ old('target_savings_products_id', $target->target_savings_products_id) }}">
                            <input type="hidden" name="customer_id" value="{{ old('customer_id', $target->customer_id) }}">
                            <input type="hidden" name="account_number" value="{{ old('account_number', $target->account_number) }}">

                            <div class="form-group">
                                <label class="col-sm-4 control-label">Target Savings Product</label>
                                <div class="col-sm-7 controls">
                                    <select id="fdproduct" class="form-control width-70" disabled
                                        data-product-url="{{ route('targetsavings.product.details', ['id' => '__ID__']) }}">
                                        <option selected disabled>Select a Target Savings Product</option>
                                        @foreach ($products as $item)
                                            <option value="{{ $item['id'] }}" @selected((int) $item['id'] === (int) $target->target_savings_products_id)>
                                                {{ $item['name'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <img src="/img/loading.gif" id="lpdttext" style="display:none" alt="loading">
                                    <p id="product-hint" style="margin-top:8px; display:none; color: green;"></p>
                                </div>
                            </div>

                            <!-- Customers Account Number (disabled but visible) -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Customers Account Number</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control" type="text" id="acno" name="acctno"
                                        value="{{ $target->account_number }}" disabled autocomplete="off"
                                        placeholder="0099998474" inputmode="numeric" pattern="\d{10}" maxlength="10"
                                        aria-describedby="acno-help acno-error"
                                        data-lookup-url="{{ route('targetsavings.customer.details', ['account' => '__ACC__']) }}">
                                    <small id="acno-help" class="text-muted">Enter exactly 10 digits.</small>
                                    <div id="acno-error" class="text-danger" style="display:none; margin-top:6px;"></div>
                                    <img src="/img/loading.gif" id="sttext" style="display:none; margin-top:6px;" alt="loading">
                                </div>
                            </div>

                            @php
                                $custName = trim(($customer->first_name ?? '') . ' ' . ($customer->last_name ?? ''));
                            @endphp
                            <div class="form-group" id="cbl" style="display:block; margin-top:10px;">
                                <label class="col-sm-4 control-label"></label>
                                <div class="col-sm-7 controls">
                                    <div>
                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer Name:</label>
                                            <input type="text" id="customer_name" name="customer_name"
                                                value="{{ old('customer_name', $custName) }}" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>

                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer Account Number:</label>
                                            <input type="text" id="customer_acctno" name="account_number_display"
                                                value="{{ $target->account_number }}" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>

                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer Account Balance:</label>
                                            <input type="text" id="account_balance" name="account_balance"
                                                value="{{ number_format((float)($customer->account_balance ?? 0), 2) }}" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-4 control-label">Saving Plan Name</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control" type="text" name="savings_plan_name"
                                        id="savings_plan_name" autocomplete="off" placeholder="House Rent"
                                        value="{{ old('savings_plan_name', $target->savings_plan_name) }}">
                                    @error('savings_plan_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-4 control-label">Target Amount</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control money-input" type="text" name="target_amount"
                                        id="target_amount" autocomplete="off" placeholder="Minimum of ₦5000"
                                        inputmode="numeric"
                                        value="{{ old('target_amount', number_format((float) $target->target_amount, 0, '.', ',')) }}">
                                    @error('target_amount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <hr>
                            <h5 class="text-danger">Payments:</h5><br>

                            <!-- Auto Save toggle -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label"></label>
                                <div class="col-sm-7 controls">
                                    <div class="vd_checkbox checkbox-success">
                                        <input type="checkbox" name="auto_save" value="1" id="checkbox-1"
                                            {{ old('auto_save', (int) $target->auto_save) ? 'checked' : '' }}>
                                        <label for="checkbox-1">Auto Save</label>
                                    </div>
                                    @error('auto_save')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Auto Save dependent fields (hidden until checked) -->
                            <div id="auto-save-fields" style="display:none;">
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Save Now Amount</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control money-input" type="text"
                                            name="auto_save_amount" id="auto_save_amount" placeholder="₦5,000"
                                            inputmode="numeric"
                                            value="{{ old('auto_save_amount', number_format((float) $target->auto_save_amount, 0, '.', ',')) }}">
                                        @error('auto_save_amount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Frequency</label>
                                    <div class="col-sm-7 controls">
                                        <select name="frequency" id="frequency" class="form-control width-70">
                                            <option value="daily" @selected(old('frequency', $target->frequency) === 'daily')>Daily</option>
                                            <option value="weekly" @selected(old('frequency', $target->frequency) === 'weekly')>Weekly</option>
                                            <option value="monthly" @selected(old('frequency', $target->frequency) === 'monthly')>Monthly</option>
                                        </select>
                                        <img src="/img/loading.gif" id="lpdttext2" style="display:none" alt="loading">
                                        @error('frequency')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Auto Save Start Date</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="date" name="auto_save_start_date"
                                            id="dsdate"
                                            value="{{ old('auto_save_start_date', \Carbon\Carbon::parse($target->auto_save_start_date ?? now())->toDateString()) }}">
                                        @error('auto_save_start_date')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div class="form-group form-actions">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-7">
                                    <button class="btn vd_btn vd_bg-green vd_white" type="submit" id="btnssubmit">
                                        Update Target Savings
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script>
        (function() {
            const selectEl = document.getElementById('fdproduct');
            const hintEl = document.getElementById('product-hint');
            const spinner = document.getElementById('lpdttext');
            const targetAmt = document.getElementById('target_amount');
            const urlTemplate = selectEl.getAttribute('data-product-url');

            function naira(n) {
                const num = Number(n || 0);
                try {
                    return new Intl.NumberFormat('en-NG', { style: 'currency', currency: 'NGN', minimumFractionDigits: 0, maximumFractionDigits: 0 }).format(num);
                } catch (_) {
                    return '₦' + (num.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ','));
                }
            }

            async function loadCurrent() {
                const id = "{{ (int) $target->target_savings_products_id }}";
                if (!id) return;
                spinner.style.display = 'inline-block';
                hintEl.style.display = 'none';
                hintEl.textContent = '';
                const url = urlTemplate.replace('__ID__', encodeURIComponent(id));
                try {
                    const res = await fetch(url, { headers: { 'X-Requested-With': 'XMLHttpRequest' } });
                    const json = await res.json().catch(() => ({}));
                    spinner.style.display = 'none';
                    if (!res.ok || !json || json.status !== 'success' || !json.data) {
                        hintEl.textContent = 'Unable to load product details.';
                        hintEl.style.display = 'block';
                        return;
                    }
                    const d = json.data;
                    const rate = (Number(d.interest_rate) || 0).toFixed(2).replace(/\.00$/, '');
                    const minTarget = naira(d.minimum_target_deposit);
                    hintEl.textContent = `Interest Rate of ${rate}% Per Annum and Minimum Target Deposit of ${minTarget}`;
                    hintEl.style.display = 'block';

                    if (targetAmt) {
                        targetAmt.placeholder = `Minimum of ${minTarget}`;
                        const minVal = Number(d.minimum_target_deposit) || 0;
                        targetAmt.min = minVal > 0 ? String(minVal) : '0';
                    }
                } catch (e) {
                    spinner.style.display = 'none';
                    hintEl.textContent = 'Network error. Please try again.';
                    hintEl.style.display = 'block';
                }
            }

            loadCurrent();
        })();
    </script>

    <script>
        (function() {
            function onlyDigits(v) { return String(v ?? '').replace(/[^\d]/g, ''); }
            function formatThousands(v) {
                v = onlyDigits(v);
                if (v === '') return '';
                const n = Number(v);
                if (isNaN(n)) return '';
                return n.toLocaleString('en-NG');
            }

            const inputs = document.querySelectorAll('.money-input');

            inputs.forEach((el) => {
                el.addEventListener('input', function() {
                    const wasFocused = document.activeElement === el;
                    el.value = formatThousands(el.value);
                    if (wasFocused) {
                        const len = el.value.length;
                        el.setSelectionRange(len, len);
                    }
                });

                el.addEventListener('blur', function() {
                    el.value = formatThousands(el.value);
                });

                if (el.value) el.value = formatThousands(el.value);
            });

            const form = document.getElementById('submitfd');
            form.addEventListener('submit', function() {
                inputs.forEach((el) => { el.value = onlyDigits(el.value); });
            });

            // === Auto Save show/hide ===
            const autoSaveCheckbox = document.getElementById('checkbox-1');
            const autoSaveFields   = document.getElementById('auto-save-fields');

            function refreshAutoSaveVisibility() {
                const show = !!autoSaveCheckbox.checked;
                autoSaveFields.style.display = show ? '' : 'none';
            }

            // set initial visibility based on current checked state (old()/model)
            refreshAutoSaveVisibility();
            autoSaveCheckbox.addEventListener('change', refreshAutoSaveVisibility);
        })();
    </script>
@endsection
