@extends('layout.app')
@section('title', 'Create Target Savings')
@section('pagetitle', 'Create Target Savings')

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <div style="text-align:end">
                            <a href="{{ route('targetsavings.manage') }}" class="btn btn-danger">
                                <span class="menu-icon"><i class="fa fa-angle-left"></i></span> Back
                            </a>
                        </div>
                    </div>

                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                {{-- @include('includes.errors')
                                @include('includes.success') --}}

                                {{-- SUCCESS --}}
                                @if (session('success'))
                                    <div
                                        style="
        background:#d4ffd4;
        border:1px solid #4CAF50;
        padding:12px;
        margin-bottom:12px;
        border-radius:5px;
        color:#155724;
        font-weight:600;
        position:relative;
    ">
                                        <span>{{ session('success') }}</span>
                                        <span onclick="this.parentElement.remove();"
                                            style="position:absolute;right:10px;top:5px;cursor:pointer;font-weight:bold;font-size:18px;">
                                            &times;
                                        </span>
                                    </div>
                                @endif

                                {{-- ERROR --}}
                                @if (session('error'))
                                    <div
                                        style="
        background:#ffe5e5;
        border:1px solid #d9534f;
        padding:12px;
        margin-bottom:12px;
        border-radius:5px;
        color:#721c24;
        font-weight:600;
        position:relative;
    ">
                                        <span>{{ session('error') }}</span>
                                        <span onclick="this.parentElement.remove();"
                                            style="position:absolute;right:10px;top:5px;cursor:pointer;font-weight:bold;font-size:18px;">
                                            &times;
                                        </span>
                                    </div>
                                @endif

                                {{-- VALIDATION ERRORS --}}
                                @if ($errors->any())
                                    <div
                                        style="
        background:#ffe5e5;
        border:1px solid #d9534f;
        padding:12px;
        margin-bottom:12px;
        border-radius:5px;
        color:#721c24;
        position:relative;
    ">
                                        <ul style="margin:0; padding-left:18px;">
                                            @foreach ($errors->all() as $err)
                                                <li style="font-weight:600;">{{ $err }}</li>
                                            @endforeach
                                        </ul>

                                        <span onclick="this.parentElement.remove();"
                                            style="position:absolute;right:10px;top:5px;cursor:pointer;font-weight:bold;font-size:18px;">
                                            &times;
                                        </span>
                                    </div>
                                @endif


                                {{-- @if (session('success'))
                                    <div class="alert alert-success alert-dismissible fade in" role="alert"
                                        style="margin-bottom:12px">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ session('success') }}
                                    </div>
                                @endif

                                @if (session('error'))
                                    <div class="alert alert-danger alert-dismissible fade in" role="alert"
                                        style="margin-bottom:12px">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ session('error') }}
                                    </div>
                                @endif

                                @if ($errors->any())
                                    <div class="alert alert-danger alert-dismissible fade in" role="alert"
                                        style="margin-bottom:12px">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        <ul class="mb-0" style="margin:0;padding-left:18px">
                                            @foreach ($errors->all() as $err)
                                                <li>{{ $err }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif --}}


                            </div>
                        </div>

                        <form class="form-horizontal" action="{{ route('targetsavings.store') }}" method="post"
                            role="form" id="submitfd" enctype="multipart/form-data">
                            @csrf

                            <!-- Target Savings Product -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Target Savings Product</label>
                                <div class="col-sm-7 controls">
                                    <select name="target_savings_products_id" required id="fdproduct"
                                        class="form-control width-70"
                                        data-product-url="{{ route('targetsavings.product.details', ['id' => '__ID__']) }}">
                                        <option selected disabled>Select a Target Savings Product</option>
                                        @foreach ($products as $item)
                                            <option value="{{ $item['id'] }}">{{ $item['name'] }}</option>
                                        @endforeach
                                    </select>
                                    <img src="/img/loading.gif" id="lpdttext" style="display:none" alt="loading">
                                    <p id="product-hint" style="margin-top:8px; display:none; color: green;"></p>
                                    @error('target_savings_products_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Customers Account Number -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Customers Account Number</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control" type="text" id="acno" name="acctno"
                                        required autocomplete="off" placeholder="0099998474" inputmode="numeric"
                                        pattern="\d{10}" maxlength="10" aria-describedby="acno-help acno-error"
                                        data-lookup-url="{{ route('targetsavings.customer.details', ['account' => '__ACC__']) }}">
                                    <small id="acno-help" class="text-muted">Enter exactly 10 digits.</small>
                                    <div id="acno-error" class="text-danger" style="display:none; margin-top:6px;"></div>
                                    <img src="/img/loading.gif" id="sttext" style="display:none; margin-top:6px;"
                                        alt="loading">
                                    @error('acctno')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Customer details (single-line layout, inline style, no background) -->
                            <div class="form-group" id="cbl" style="display:none; margin-top:10px;">
                                <label class="col-sm-4 control-label"></label>
                                <div class="col-sm-7 controls">
                                    <div>
                                        <div style="display:none; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer ID:</label>
                                            <input type="hidden" id="customer_id_display" value="" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px;">
                                            <input type="hidden" name="customer_id" id="customer_id" value="">
                                        </div>

                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer
                                                Name:</label>
                                            <input type="text" id="customer_name" name="customer_name" value=""
                                                readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>

                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer Account
                                                Number:</label>
                                            <input type="text" id="customer_acctno" name="account_number"
                                                value="" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>

                                        <div style="display:flex; align-items:center; gap:10px; margin:6px 0;">
                                            <label style="width:200px; margin:0; font-weight:normal;">Customer Account
                                                Balance:</label>
                                            <input type="text" id="account_balance" name="account_balance"
                                                value="" readonly
                                                style="flex:1; border:none; background:transparent; height:28px; padding:2px 6px; font-weight:700;">
                                        </div>

                                        @error('customer_id')
                                            <span class="text-danger">{{ $message }}</span><br>
                                        @enderror
                                        @error('customer_name')
                                            <span class="text-danger">{{ $message }}</span><br>
                                        @enderror
                                        @error('account_number')
                                            <span class="text-danger">{{ $message }}</span><br>
                                        @enderror
                                        @error('account_balance')
                                            <span class="text-danger">{{ $message }}</span><br>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <!-- Saving Plan Name -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Saving Plan Name</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control" type="text" name="savings_plan_name"
                                        id="savings_plan_name" autocomplete="off" placeholder="House Rent">
                                    @error('savings_plan_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Target Amount (formatted realtime, thousands only) -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Target Amount</label>
                                <div class="col-sm-7 controls">
                                    <input class="width-70 form-control money-input" type="text" name="target_amount"
                                        value="{{ old('target_amount') }}" id="target_amount" autocomplete="off"
                                        placeholder="Minimum of ₦5000" inputmode="numeric">
                                    @error('target_amount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <hr>
                            <h5 class="text-danger">Payments:</h5><br>

                            <!-- Auto Save toggle -->
                            <div class="form-group">
                                <label class="col-sm-4 control-label"></label>
                                <div class="col-sm-7 controls">
                                    <div class="vd_checkbox checkbox-success">
                                        <input type="checkbox" name="auto_save" value="1" id="checkbox-1"
                                            {{ old('auto_save', 0) ? 'checked' : '' }}>
                                        <label for="checkbox-1">Auto Save</label>
                                    </div>
                                    @error('auto_save')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <!-- Auto Save dependent fields (hidden until checked) -->
                            <div id="auto-save-fields" style="display:none;">
                                <!-- Save Now Amount -->
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Auto Save Amount</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control money-input" type="text"
                                            name="auto_save_amount" value="{{ old('auto_save_amount') }}"
                                            id="auto_save_amount" placeholder="₦5,000" inputmode="numeric">
                                        @error('auto_save_amount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Frequency -->
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Frequency</label>
                                    <div class="col-sm-7 controls">
                                        <select name="frequency" id="frequency" class="form-control width-70">
                                            <option value="daily">Daily</option>
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly" selected>Monthly</option>
                                        </select>
                                        <img src="/img/loading.gif" id="lpdttext2" style="display:none" alt="loading">
                                        @error('frequency')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Auto Save Start Date -->
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Auto Save Start Date</label>
                                    <div class="col-sm-7 controls">
                                        <input class="width-70 form-control" type="date" name="auto_save_start_date"
                                            id="dsdate" value="{{ old('auto_save_start_date', '2025-10-20') }}">
                                        @error('auto_save_start_date')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div class="form-group form-actions">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-7">
                                    <button class="btn vd_btn vd_bg-green vd_white" type="submit" id="btnssubmit">
                                        Create Target Savings
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Product details fetch -->
    <script>
        (function() {
            const selectEl = document.getElementById('fdproduct');
            const hintEl = document.getElementById('product-hint');
            const spinner = document.getElementById('lpdttext');
            const targetAmt = document.getElementById('target_amount');
            const urlTemplate = selectEl.getAttribute('data-product-url');

            function naira(n) {
                const num = Number(n || 0);
                try {
                    return new Intl.NumberFormat('en-NG', {
                        style: 'currency',
                        currency: 'NGN',
                        minimumFractionDigits: 0,
                        maximumFractionDigits: 0
                    }).format(num);
                } catch (_) {
                    return '₦' + (num.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ','));
                }
            }

            async function onChange() {
                const id = selectEl.value;
                if (!id) {
                    hintEl.style.display = 'none';
                    hintEl.textContent = '';
                    return;
                }

                spinner.style.display = 'inline-block';
                hintEl.style.display = 'none';
                hintEl.textContent = '';

                const url = urlTemplate.replace('__ID__', encodeURIComponent(id));
                try {
                    const res = await fetch(url, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                    const json = await res.json().catch(() => ({}));
                    spinner.style.display = 'none';

                    if (!res.ok || !json || json.status !== 'success' || !json.data) {
                        hintEl.textContent = 'Unable to load product details.';
                        hintEl.style.display = 'block';
                        return;
                    }

                    const d = json.data;
                    const rate = (Number(d.interest_rate) || 0).toFixed(2).replace(/\.00$/, '');
                    const minTarget = naira(d.minimum_target_deposit);

                    hintEl.textContent =
                        `Interest Rate of ${rate}% Per Annum and Minimum Target Deposit of ${minTarget}`;
                    hintEl.style.display = 'block';

                    if (targetAmt) {
                        targetAmt.placeholder = `Minimum of ${minTarget}`;
                        const minVal = Number(d.minimum_target_deposit) || 0;
                        targetAmt.min = minVal > 0 ? String(minVal) : '0';
                    }
                } catch (e) {
                    spinner.style.display = 'none';
                    hintEl.textContent = 'Network error. Please try again.';
                    hintEl.style.display = 'block';
                }
            }

            selectEl.addEventListener('change', onChange);
        })();
    </script>

    <!-- Existing JS (customer lookup) -->
    <script>
        (function() {
            const acnoInput = document.getElementById('acno');
            const spinner = document.getElementById('sttext');
            const errorEl = document.getElementById('acno-error');
            const briefBox = document.getElementById('cbl');

            const customerIdHidden = document.getElementById('customer_id');
            const customerIdDisplay = document.getElementById('customer_id_display');
            const customerNameInput = document.getElementById('customer_name');
            const customerAcctnoInput = document.getElementById('customer_acctno');
            const accountBalanceInput = document.getElementById('account_balance');

            const submitBtn = document.getElementById('btnssubmit');
            const urlTemplate = acnoInput.getAttribute('data-lookup-url');

            let lastQueried = '';
            setSubmitEnabled(false);

            function sanitizeTo10Digits(value) {
                const digits = value.replace(/\D+/g, '');
                return digits.length > 10 ? digits.slice(0, 10) : digits;
            }

            function setSubmitEnabled(state) {
                if (submitBtn) submitBtn.disabled = !state;
            }

            function showSpinner(state) {
                if (spinner) spinner.style.display = state ? 'inline-block' : 'none';
            }

            function showError(msg) {
                if (!errorEl) return;
                if (msg) {
                    errorEl.textContent = msg;
                    errorEl.style.display = 'block';
                } else {
                    errorEl.textContent = '';
                    errorEl.style.display = 'none';
                }
            }

            function clearBrief() {
                if (briefBox) briefBox.style.display = 'none';
                customerIdHidden.value = customerIdDisplay.value =
                    customerNameInput.value = customerAcctnoInput.value =
                    accountBalanceInput.value = '';
                setSubmitEnabled(false);
            }

            // format with commas and 2 decimals: 1,000.00
            function formatMoney2dp(n) {
                const num = Number(n || 0);
                return isNaN(num) ?
                    '' :
                    num.toLocaleString('en-NG', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    });
            }

            function fillBrief(data) {
                customerIdHidden.value = data.customer_id ?? '';
                customerIdDisplay.value = data.customer_id ?? '';
                customerNameInput.value = data.customer_name ?? '';
                customerAcctnoInput.value = data.acctno ?? '';
                // format balances
                accountBalanceInput.value = formatMoney2dp(data.account_balance ?? '0');
                if (briefBox) briefBox.style.display = 'block';
                setSubmitEnabled(true);
            }

            async function fetchCustomer(val) {
                showError('');
                showSpinner(true);
                clearBrief();
                const url = urlTemplate.replace('__ACC__', encodeURIComponent(val));
                try {
                    const res = await fetch(url, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                    const json = await res.json().catch(() => ({}));
                    showSpinner(false);
                    if (!res.ok || !json || json.status !== 'success' || !json.data) {
                        lastQueried = '';
                        showError(json?.message || 'Unable to retrieve customer.');
                        clearBrief();
                        return;
                    }
                    fillBrief(json.data);
                } catch {
                    showSpinner(false);
                    lastQueried = '';
                    showError('Network error. Please try again.');
                    clearBrief();
                }
            }

            acnoInput.addEventListener('input', () => {
                const val = sanitizeTo10Digits(acnoInput.value);
                if (acnoInput.value !== val) acnoInput.value = val;
                if (val.length < 10) {
                    if (lastQueried !== '') lastQueried = '';
                    showError(val.length > 0 ? 'Account number must be exactly 10 digits.' : '');
                    clearBrief();
                    return;
                }
                if (val.length === 10 && val !== lastQueried) {
                    lastQueried = val;
                    fetchCustomer(val);
                }
            });
            acnoInput.addEventListener('paste', e => {
                e.preventDefault();
                const text = (e.clipboardData || window.clipboardData).getData('text') || '';
                const sanitized = sanitizeTo10Digits(text);
                acnoInput.value = sanitized;
                acnoInput.dispatchEvent(new Event('input', {
                    bubbles: true
                }));
            });
        })();
    </script>

    <!-- Money inputs (leave as-is for target/save fields) + Auto Save toggle behavior -->
    <script>
        (function() {
            function onlyDigits(v) {
                return String(v ?? '').replace(/[^\d]/g, '');
            }

            function formatThousands(v) {
                v = onlyDigits(v);
                if (v === '') return '';
                const n = Number(v);
                if (isNaN(n)) return '';
                return n.toLocaleString('en-NG'); // e.g. 1,234,567
            }

            const inputs = document.querySelectorAll('.money-input');

            inputs.forEach((el) => {
                el.addEventListener('input', function() {
                    const wasFocused = document.activeElement === el;
                    el.value = formatThousands(el.value);
                    if (wasFocused) {
                        const len = el.value.length;
                        el.setSelectionRange(len, len);
                    }
                });

                el.addEventListener('blur', function() {
                    el.value = formatThousands(el.value);
                });

                if (el.value) el.value = formatThousands(el.value);
            });

            const form = document.getElementById('submitfd');
            form.addEventListener('submit', function() {
                inputs.forEach((el) => {
                    el.value = onlyDigits(el.value); // "1,000" -> "1000"
                });
            });

            // === Auto Save show/hide ===
            const autoSaveCheckbox = document.getElementById('checkbox-1');
            const autoSaveFields = document.getElementById('auto-save-fields');

            function refreshAutoSaveVisibility() {
                const show = !!autoSaveCheckbox.checked;
                autoSaveFields.style.display = show ? '' : 'none';
            }

            // initial state (unchecked by default)
            refreshAutoSaveVisibility();
            autoSaveCheckbox.addEventListener('change', refreshAutoSaveVisibility);
        })();
    </script>

    <script>
        (function() {
            const autoSaveCheckbox = document.getElementById('checkbox-1');
            const autoSaveFields = document.getElementById('auto-save-fields');
            const saveNowInput = document.getElementById('auto_save_amount');
            const freqSelect = document.getElementById('frequency');
            const startDateInput = document.getElementById('dsdate');

            function setDisabled(disabled) {
                [saveNowInput, freqSelect, startDateInput].forEach(el => {
                    if (!el) return;
                    el.disabled = disabled;
                    if (disabled) el.value = ''; // clear values when hidden
                });
            }

            function refreshAutoSaveVisibility() {
                const on = !!autoSaveCheckbox.checked;
                autoSaveFields.style.display = on ? '' : 'none';
                setDisabled(!on);
            }

            // initialize on page load
            refreshAutoSaveVisibility();
            autoSaveCheckbox.addEventListener('change', refreshAutoSaveVisibility);
        })();
    </script>

@endsection
