@extends('layout.app')

@section('title')
    System Logs
@endsection

@section('pagetitle')
    System Logs
@endsection

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <h3 class="panel-title">System Logs</h3>
                    </div>

                    <div class="panel-body">
                        <div class="row">

                            {{-- LEFT: Log files list --}}
                            <div class="col-sm-3">
                                <h5 class="text-muted">
                                    Log Files
                                    <span class="badge">{{ count($files) }}</span>
                                </h5>

                                <div class="list-group" style="max-height: 70vh; overflow-y:auto;">
                                    @forelse ($files as $file)
                                        <a href="{{ route('system.logs', ['file' => $file]) }}"
                                           class="list-group-item {{ $file === $activeFile ? 'active' : '' }}">
                                            <div class="clearfix">
                                                <span class="pull-left text-truncate"
                                                      style="max-width: 150px; display:inline-block;">
                                                    {{ $file }}
                                                </span>
                                                @php
                                                    $sizeKb = @filesize(storage_path('logs/'.$file)) / 1024;
                                                @endphp
                                                <small class="pull-right text-muted">
                                                    @if ($sizeKb)
                                                        {{ number_format($sizeKb, 1) }} KB
                                                    @endif
                                                </small>
                                            </div>
                                        </a>
                                    @empty
                                        <p class="text-muted">
                                            No log files found in <code>storage/logs</code>.
                                        </p>
                                    @endforelse
                                </div>
                            </div>

                            {{-- RIGHT: Active log content --}}
                            <div class="col-sm-9">

                                @if ($activeFile)
                                    <div class="clearfix" style="margin-bottom:10px;">
                                        <div class="pull-left">
                                            <strong>Viewing:</strong> {{ $activeFile }} <br>
                                            @if ($fileSize)
                                                <small class="text-muted">
                                                    Size: {{ number_format($fileSize / 1024, 1) }} KB
                                                </small><br>
                                            @endif

                                            @if (!empty($truncated) && $truncated)
                                                <small class="text-warning">
                                                    Showing only the last {{ number_format($tailBytes / 1024, 1) }} KB
                                                    of this file (large log truncated).
                                                </small>
                                            @endif
                                        </div>

                                        <div class="pull-right">
                                            <a href="{{ route('system.logs', ['file' => $activeFile]) }}"
                                               class="btn btn-xs btn-default">
                                                Refresh
                                            </a>
                                        </div>
                                    </div>

                                    {{-- LOG TEXT --}}
                                    <div style="border:1px solid #ddd;
                                                max-height:70vh;
                                                overflow:auto;
                                                background:#111827;
                                                color:#e5e7eb;">
                                        <pre style="margin:0; padding:10px;
                                                    white-space:pre-wrap;
                                                    font-size:12px;
                                                    font-family:Menlo,Monaco,Consolas,'Courier New',monospace;">
{!! nl2br(e($content)) !!}
                                        </pre>
                                    </div>
                                @else
                                    <p class="text-muted">
                                        Select a log file on the left to view its contents.
                                    </p>
                                @endif

                            </div> {{-- /.col-sm-9 --}}

                        </div> {{-- /.row --}}
                    </div> {{-- /.panel-body --}}
                </div> {{-- /.panel --}}
            </div>
        </div>
    </div>
@endsection
