@extends('layout.app')

@section('title')
    System Analysis
@endsection

@section('pagetitle')
    System Analysis
@endsection

@section('content')
    <div class="container">
        <div class="row" id="advanced-input">
            <div class="col-md-12">
                <div class="panel widget">
                    <div class="panel-heading">
                        <h3 class="panel-title text-danger">System Performance & Memory Analysis</h3>
                    </div>

                    <div class="panel-body">

                        {{-- SUMMARY CARDS --}}
                        <div class="row" style="margin-bottom:20px;">
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <div class="h4">{{ $summary['total_entries'] }}</div>
                                    <div class="text-muted">Total Samples (memprof.log)</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    <div class="h4">{{ $summary['total_routes'] }}</div>
                                    <div class="text-muted">Unique Endpoints</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    @if($summary['most_called'])
                                        <div class="small text-muted">Most Called Route</div>
                                        <div style="font-size:12px; word-break:break-all;">
                                            {{ $summary['most_called']['route'] }}
                                        </div>
                                        <div class="small text-muted">
                                            {{ $summary['most_called']['count'] }} calls
                                            ({{ number_format($summary['most_called']['percentage'], 1) }}%)
                                        </div>
                                    @else
                                        <div class="text-muted">No Data</div>
                                    @endif
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="well text-center">
                                    @if($summary['slowest_route'])
                                        <div class="small text-muted">Slowest (Avg)</div>
                                        <div style="font-size:12px; word-break:break-all;">
                                            {{ $summary['slowest_route']['route'] }}
                                        </div>
                                        <div class="small text-muted">
                                            {{ number_format($summary['slowest_route']['avg_duration'], 1) }} ms avg
                                        </div>
                                    @else
                                        <div class="text-muted">No Data</div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        @if ($summary['total_entries'] == 0)
                            <p class="text-muted">
                                No data found in <code>storage/logs/memprof.log</code>.
                                Make sure your profiler is writing JSON lines into this file.
                            </p>
                        @else
                            <div class="row">

                                {{-- MOST CALLED ROUTES --}}
                                <div class="col-sm-6">
                                    <h4>Most Called Routes</h4>
                                    <div class="table-responsive" style="max-height: 55vh; overflow:auto;">
                                        <table class="table table-striped table-condensed">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Route</th>
                                                <th class="text-right">Calls</th>
                                                <th class="text-right">% of Total</th>
                                                <th class="text-right">Avg Time (ms)</th>
                                                <th class="text-right">Avg Mem</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @forelse ($byCount as $index => $row)
                                                <tr>
                                                    <td>
                                                        {{ $byCount->firstItem() + $index }}
                                                    </td>
                                                    <td style="max-width: 220px; word-break: break-all;">
                                                        @if (!empty($row['is_api']) && $row['is_api'])
                                                            <span class="label label-info">API</span>
                                                        @endif
                                                        {{ $row['route'] }}
                                                    </td>
                                                    <td class="text-right">{{ $row['count'] }}</td>
                                                    <td class="text-right">
                                                        {{ number_format($row['percentage'], 1) }}%
                                                    </td>
                                                    <td class="text-right">
                                                        {{ number_format($row['avg_duration'], 1) }}
                                                    </td>
                                                    <td class="text-right">
                                                        {{ number_format($row['avg_memory'], 2) }}
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-muted text-center">
                                                        No route data available.
                                                    </td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>

                                    {{-- PAGINATION FOR MOST CALLED --}}
                                    <div class="text-center">
                                        {{ $byCount->links() }}
                                    </div>
                                </div>

                                {{-- SLOWEST ROUTES --}}
                                <div class="col-sm-6">
                                    <h4>Slowest Routes (Avg Duration)</h4>
                                    <div class="table-responsive" style="max-height: 55vh; overflow:auto;">
                                        <table class="table table-striped table-condensed">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Route</th>
                                                <th class="text-right">Calls</th>
                                                <th class="text-right">Avg Time (ms)</th>
                                                <th class="text-right">Max Time (ms)</th>
                                                <th class="text-right">Max Mem</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @forelse ($byAvgDuration as $index => $row)
                                                <tr>
                                                    <td>
                                                        {{ $byAvgDuration->firstItem() + $index }}
                                                    </td>
                                                    <td style="max-width: 220px; word-break: break-all;">
                                                        @if (!empty($row['is_api']) && $row['is_api'])
                                                            <span class="label label-info">API</span>
                                                        @endif
                                                        {{ $row['route'] }}
                                                    </td>
                                                    <td class="text-right">{{ $row['count'] }}</td>
                                                    <td class="text-right">
                                                        {{ number_format($row['avg_duration'], 1) }}
                                                    </td>
                                                    <td class="text-right">
                                                        {{ number_format($row['max_duration'], 1) }}
                                                    </td>
                                                    <td class="text-right">
                                                        {{ number_format($row['max_memory'], 2) }}
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-muted text-center">
                                                        No route data available.
                                                    </td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>

                                    {{-- PAGINATION FOR SLOWEST --}}
                                    <div class="text-center">
                                        {{ $byAvgDuration->links() }}
                                    </div>
                                </div>

                            </div>
                        @endif

                    </div> {{-- /.panel-body --}}
                </div> {{-- /.panel --}}
            </div>
        </div>
    </div>
@endsection
