@extends('layout.app')
@section('title')
Inward Transaction
@endsection
@section('pagetitle')
Inward Transaction
@endsection
@section('content')
  <div class="container">
    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                  <div class="panel-heading">
                    <h4>Inward Transaction</h4>
                  </div>
                  <div class="panel-body">  
                    <div class="noprint" style="margin-bottom: 15px">
                      <form action="{{route('report.inward')}}" method="get" onsubmit="thisForm()">
                        <input type="hidden" name="filter" value="true">
                        <table class="table table-bordered table-hover table-sm">
                          <thead>
                            <tr>
                              <th>From Date</th>
                              <th>To Date</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                              <td>
                                <div class="form-group">
                                  <input type="date" name="datefrom" required id="" class="form-control" value="{{!empty($_GET['datefrom']) ? $_GET['datefrom'] : ''}}">
                                </div>
                              </td>
                              <td>
                                <div class="form-group">
                                  <input type="date" name="dateto" required id="" class="form-control" value="{{!empty($_GET['dateto']) ? $_GET['dateto'] : ''}}">
                                </div>
                              </td>
                             
                              <td>
                                <button type="submit" class="btn btn-success btn-sm" id="btnsetsubmit">Generate Report</button>
                                <button type="button" class="btn btn-danger btn-sm" onclick="window.location.href='{{route('report.inward')}}'">Reset</button>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </form>
                    </div>
                          <div class="table-responsive">
                            <table id="success" class="table table-bordered table-striped table-condensed table-hover">
                                <thead>
                                <tr>
                                     <th>S/N</th>
                                     <th><b>Account Name</b></th>
                                     <th><b>Account No</b></th>
                                     <th><b>Amount</b></th>
                                     <th><b>Description</b></th>
                                     <th><b>Reference</b></th>
                                     <th><b>Transaction Date</b></th>
                                    </tr>
                                </thead>
                                <tbody>
                                  <?php $i=0; ?>

                                @foreach($paylods as $key)
                                    <tr>
                                         <td>{{ $i+1 }}</td>  
                                        <td style="width: 23%">{{ ucwords($key->customer->first_name." ".$key->customer->last_name)}}</td>
                                        <td> {{$key->customer->acctno}}</td>
                                        <td>{{number_format($key->amount,2)}} </td>
                                        <td> {{$key->reference_no}}</td>
                                        <td>{{$key->notes}}  </td>
                                     
                                       <td style="width: 15%">{{date("d-m-Y h:ia",strtotime($key->created_at))}}</td>
                                           
                                    </tr>
                                    <?php $i++; ?>
                                @endforeach
                                
                                </tbody>
                            </table>
                        </div>
                          
                  </div>
                </div>
                <!-- Panel Widget --> 

              </div>
              <!-- col-md-12 --> 
            </div>
            <!-- row -->
  </div>
@endsection
@section('scripts')
<script type="text/javascript">
  $(document).ready(function(){
    $("#success").dataTable({
    'pageLength':50,
    'dom': 'Bfrtip',
      buttons: [ 'copy', 'csv', 'print','pdf']
  });
  
  });
</script>
@endsection