<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Account Statement</title>
</head>
<body>
    <h1>Account Statement</h1>
    <p>User: {{ $user->name ?? 'Customer' }}</p>
    <p>From: {{ $from->format('d-m-Y') }} | To: {{ $to->format('d-m-Y') }}</p>

    <table border="1" cellpadding="5" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th>#</th>
            <th>Date/Time</th>
            <th>Description</th>
            <th>Type</th>
            <th>Amount</th>
        </tr>
        </thead>
        <tbody>
        @foreach($transactions as $i => $t)
            <tr>
                <td>{{ $i + 1 }}</td>
                <td>{{ $t->created_at }}</td>
                <td>{{ $t->description ?? '-' }}</td>
                <td>{{ $t->type ?? '-' }}</td>
                <td>{{ $t->amount ?? 0 }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</body>
</html>
