@extends('layout.app')
@section('title')
    Customer Balance
@endsection
@section('pagetitle')
Customer Balance
@endsection
@section('content')
  <div class="container">
    <?php 
         $getsetvalue = new \App\Models\Setting();
     ?>
    <div class="row" id="advanced-input">
              <div class="col-md-12">
                <div class="panel widget">
                  <div class="panel-heading">
                    <div style="text-align: end">
                      <?php
                      $filter = !empty($_GET['filter']) ? "?filter=".$_GET['filter'] : "";
                      $search = !empty($_GET['csdetails']) ? "&searchval=".$_GET['csdetails'] : "";
                      ?>
                      <a href="{{ route('customer.balance.export') }}{{$filter."".$search}}" class="btn btn-primary btn-sm"><span class="menu-icon"> <i class="fa fa-file-excel-o"></i> </span> Export Excel</a>
                        <a href="{{route('customer.create')}}" class="btn btn-default btn-sm"><span class="menu-icon"> <i class="fa fa-plus"></i> </span> Add Customer</a>
                    </div>
                  </div>
                  <div class="panel-body">
                    <div class="noprint" style="margin-bottom: 15px">
                      <form action="{{route('savings.cutomers.balance')}}" method="get" onsubmit="thisForm()">
                        <input type="hidden" name="filter" value="true">
                        <table class="table table-bordered table-hover table-sm">
                          <thead>
                            <tr>
                              <th>Customer Name / Account Number</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                            
                              <td>
                                <div class="form-group">
                                  <input type="text" name="csdetails" required id="" class="form-control" value="{{!empty($_GET['csdetails']) ? $_GET['csdetails'] : ''}}">
                                </div>
                              </td>
                                                        
                               <td>
                                <button type="submit" class="btn btn-success btn-sm" id="btnsetsubmit">Search</button>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </form>
                    </div>
                   
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-condensed table-hover table-sm" id="acoff">
                            <thead>
                                <tr style="background-color: #D1F9FF">
                                    <th>Sn</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Business Name</th>
                                    <th>Account No</th>
                                    <th>Account Type</th>
                                    <th>Account Officer</th>
                                    <th>Balance</th>
                                    @if (Auth::user()->account_type == "system")
                                    <th>Recon bal</th>
                                    @endif
                                    <th>Action</th>
                                </tr>
                            </thead>    
                            <tbody>
                                <?php $i=0;?>
                                @foreach($customersbal as $key)
                                <?php 
                                $getsave = DB::table('savings')->select('account_balance','savings_product_id')
                                                            ->where('customer_id',$key->id)->first();

                                $getproname = DB::table('savings_products')->select('name')
                                                            ->where('id',$getsave->savings_product_id)->first();
                                                            
                                $creditTrnx = \App\Models\SavingsTransaction::where('customer_id',$key->id)
                                                                ->whereIn('status',['approved','failed'])
                                                              ->whereIn('type',["deposit","credit","dividend","interest","fixed_deposit","fd_interest","rev_withdrawal"])
                                                              ->sum('amount');
                                $debitTrnx = \App\Models\SavingsTransaction::where('customer_id',$key->id)
                                                                ->whereIn('status',['approved','failed'])
                                                              ->whereIn('type',["withdrawal","debit","rev_deposit"])
                                                              ->sum('amount');
                               ?>
                                  <tr>
                                  <td>{{ $i+1 }}</td> 
                                      <td>{{ $key->first_name }}</td>
                                      <td> {{ $key->last_name }}</td> 
                                      <td> {{!is_null($key->business_name) ? ucwords($key->business_name) : "N/A"}}</td> 
                                      <td>{{$key->acctno}}</td> 
                                      <td>{{!empty($getproname) ? $getproname->name : "N/A"}}</td>                       
                                       <td> {{!is_null($key->accountofficer) ? $key->accountofficer->full_name : "N/A"}}</td>
                                     
                                      <td>
                                          {{number_format($getsave->account_balance,2)}}
                                      </td>
                                      @if (Auth::user()->account_type == "system")
                                      <?php 
                                       $recnlin = $creditTrnx - $debitTrnx;
                                      ?>
                                      <td>
                                          {{number_format($recnlin,2)}}
                                      </td>
                                      @endif
                                      <td>
                                          @can('view savings')
                                          <a href="{{route('saving.transaction.details',['id' => $key->id])}}" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> Details</a>
                                          @endcan
                                      </td>
                                  </tr>
                                  <?php $i++; ?>
                                  @endforeach
                            </tbody>
                        </table>
                    </div>
                      <div class="row" style="float: right;margin:5px">
                      {{$customersbal->links()}}
                    </div>
                  </div>
                </div>
                <!-- Panel Widget --> 
              </div>
              <!-- col-md-12 --> 
            </div>
            <!-- row -->
  </div>
@endsection
@section('scripts')
    <script type="text/javascript">
  $(document).ready(function(){
    $("#acoff").dataTable({
      'paging': false,
      'searching': false,
      'info': false
      // 'pageLength':25,
      // 'dom': 'Bfrtip',
      //   buttons: [ 'copy', 'csv', 'print','pdf']
    });
  });
</script>
@endsection