#!/bin/bash
set -e

DATE_WITH_TIME=$(date "+%Y%m%d.%H%M%S")

GITHUB_USERNAME="victorikhianosen"
IMAGE_NAME="assetmatrix-cba"
REGISTRY="ghcr.io"

IMAGE_TAG=${REGISTRY}/${GITHUB_USERNAME}/${IMAGE_NAME}:prod_${DATE_WITH_TIME}

echo "🔨 Building -> ${IMAGE_TAG}"

docker build --no-cache -t ${IMAGE_TAG} .

echo "🚀 Pushing image"
docker push ${IMAGE_TAG}

echo "✅ Image pushed successfully:"
echo "${IMAGE_TAG}"
