<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_savings_profits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->nullable();
            $table->foreignId('user_id')->nullable();
            $table->foreignId('branch_id')->nullable();
            $table->string('account_number')->nullable();
            $table->decimal('interest_rate_percent', 8, 4);
            $table->decimal('balance_basis', 30, 2)->nullable();
            $table->decimal('profit_amount', 30, 2)->nullable();
            $table->decimal('withdrawals_total', 30,2)->nullable();
            $table->string('status')->default('pending');
            $table->string('reference')->nullable();
                        $table->string('month')->nullable();

            $table->string('initiated_by')->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_savings_profits');
    }
};
