<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        Schema::create('target_savings_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('target_savings_id')->constrained('target_savings')->cascadeOnUpdate()->restrictOnDelete();
            $table->foreignId('target_savings_schedule_id')->nullable()->constrained('target_savings_schedules')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('customer_id')->nullable()->constrained('customers')->cascadeOnUpdate()->setNullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->cascadeOnUpdate()->setNullOnDelete();
            $table->string('target_savings_code');
            $table->string('type', 50);
            $table->decimal('amount', 20, 2);
            $table->string('reference_no')->nullable();
            $table->string('external_reference')->nullable();
            $table->string('narration')->nullable();
            $table->string('status')->nullable();
            $table->string('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->text('device')->nullable();

            $table->string('initiated_by')->nullable();
            $table->timestamp('initiated_at')->nullable();

            $table->string('disbursed_by')->nullable();
            $table->timestamp('disbursed_at')->nullable();

            $table->text('note')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('target_savings_transactions');
    }
};
