<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        Schema::create('target_savings_products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('user_id');
            $table->string('product_code')->unique();
            $table->decimal('minimum_deposit', 30, 2)->default(0);
            $table->decimal('interest_rate', 30, 2);
            $table->unsignedInteger('minimum_hold_days')->default(30);
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('target_savings_products');
    }
};
