<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whatsapp_ussd_sessions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->nullable();
            $table->string('branch_id')->nullable();
            $table->dateTime('session_time')->nullable();
            $table->string('session_status')->nullable();
            $table->string('operation')->nullable();
            $table->string('phone')->nullable();
            $table->string('amount')->nullable();
            $table->string('vtu_phone')->nullable();
            $table->string('vtu_code')->nullable();
            $table->string('vtu_network')->nullable();
            $table->string('variation_code')->nullable();
            $table->string('type')->nullable();
            $table->string('bank_code')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_name')->nullable();
            $table->string('bankcode')->nullable();
            $table->text('datalist')->nullable();
            $table->text('cablelist')->nullable();
            $table->text('electlist')->nullable();
            $table->enum('channel_type',['whatsapp','ussd'])->nullable();
            $table->string('sessionid')->nullable();
            $table->string('transaction_type')->nullable();
            $table->string('statement_date')->nullable();
            $table->string('userp')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whatsapp_ussd_sessions');
    }
};
