<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable();
            $table->foreignId('branch_id')->nullable();
            $table->foreignId('accountofficer_id')->nullable();
            $table->string('title')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('middle_name')->nullable();
            $table->string('mother_name')->nullable();

            $table->string('email');
            $table->string('phone');
            $table->string('gender');
            $table->string('religion');
            $table->string('gender');
            $table->string('section');
            $table->string('marital_status');
            $table->string('residential_address');
            $table->date('dob');
            $table->string('country')->nullable();
            $table->string('state');
            $table->string('state_lga');
            $table->string('account_type')->nullable();
            $table->string('account_category')->nullable();
            $table->foreignId('exchangerate_id')->nullable();
            $table->string('acctno');
            $table->text('refacct')->nullable();
            $table->integer('bvn')->nullable();
            $table->integer('nin')->nullable();
            $table->string('next_kin');
            $table->string('kin_address')->nullabAle();
            $table->string('kin_phone')->nullable();
            $table->string('kin_relate')->nullable();
            $table->string('maiden');
            $table->string('occupation');
            $table->string('business_name')->nullable();
            $table->string('working_status')->nullable();
            $table->text('question')->nullable();
            $table->text('answer')->nullable();
            $table->string('means_of_id');
            $table->string('upload_id');
            $table->string('photo')->nullable();
            $table->string('signature')->nullable();
            $table->string('username')->nullable();
            $table->string('pin')->nullable();
            $table->string('otp')->nullable();
            $table->dateTime('otp_expiration_date')->nullable();
            $table->boolean('phone_verify')->default('0');
            $table->string('password')->nullable();
            $table->string('reg_date')->nullable();
            $table->enum('source', ['online', 'admin'])->nullable();
            $table->string('failed_logins')->nullable();
            $table->string('transfer_limit')->nullable();
            $table->string('online_transfer_limit')->nullable();
            $table->string('failed_balance')->nullable();
            $table->string('failed_pin')->nullable();
            $table->string('status')->nullable();
            $table->string('lien')->nullable();
            $table->boolean('lien_status')->nullable();
            $table->string('lien_amount')->nullable();
            $table->string('referral_code')->nullable();
            $table->string('referral')->nullable();
            $table->tinyInteger('status');
            $table->boolean('whatsapp')->default('0');
            $table->boolean('ussd')->default('0');
            $table->boolean('enable_sms_alert')->default(0);
            $table->boolean('enable_sms_alert')->default(0);
            $table->boolean('internet_banking')->default(0);
            $table->string('device_id')->nullable();
            $table->string('device_token')->nullable();
            $table->enum('ctype', ['savings', 'cooperate'])->default('savings');
            $table->string('referee_name')->nullable();
            $table->string('referee_phone')->nullable();
            $table->string('referee_bank')->nullable();
            $table->string('referee_account_no')->nullable();
            $table->string('refferre_name')->nullable();
            $table->string('refferre_phone')->nullable();
            $table->string('refferre_bank')->nullable();
            $table->string('refferre_account_no')->nullable();
            $table->string('cac_no')->nullable();
            $table->date('incorporated_date')->nullable();
            $table->string('tax_id')->nullable();



            $table->string('external_account_provider')->nullable();
            $table->string('external_account_status')->default('pending');
            $table->unsignedTinyInteger('external_account_attempts')->nullable()->default(0);
            $table->json('external_account_payload')->nullable();
            $table->json('external_account_response')->nullable();


            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
};
