<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('gender')->nullable();
            $table->text('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('city')->nullable();
            $table->foreignId('role_id')->nullable();
            $table->timestamp('last_login')->nullable();
            $table->string('two_factor_code')->nullable();
            $table->dateTime('two_factor_expire_at')->nullable();
            $table->tinyInteger('is_2fa_enable')->nullable();
            $table->boolean('status')->default('0');
            $table->text('notes')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('account_type');
            $table->string('signature')->nullable();
            $table->enum('ctype',['savings','cooperate'])->default('savings');
            $table->string('referee_name')->nullable();
            $table->string('referee_phone')->nullable();
            $table->string('referee_bank')->nullable();
            $table->string('referee_account_no')->nullable();
            $table->string('refferre_name')->nullable();
            $table->string('refferre_phone')->nullable();
            $table->string('refferre_bank')->nullable();
            $table->string('refferre_account_no')->nullable();
            $table->string('cac_no')->nullable();
            $table->date('incorporated_date')->nullable();
            $table->string('tax_id')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
