<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WhatsappUssdSession extends Model
{
    use HasFactory;

    protected $fillable=[
        'customer_id','branch_id','session_time','session_status','operation','phone','amount','vtu_phone','vtu_code','vtu_network','variation_code','type','bank_code','bank_name','account_number','account_name','channel_type','sessionid','transaction_type','statement_date','userp'
    ];

    public function customer(){
        return $this->belongsTo(Customer::class,'customer_id');
    }

    protected $casts =[
        'bankcode' => 'array',
        'datalist' => 'array',
        'cablelist' => 'array',
        'electlist' => 'array'
    ];
}
