<?php

namespace App\Mail;

use App\Models\TargetSavings;
use App\Models\TargetSavingsSchedule;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TargetSavingsScheduleFailed extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public TargetSavings $target;
    public TargetSavingsSchedule $schedule;
    public string $reason;

    public function __construct(TargetSavings $target, TargetSavingsSchedule $schedule, string $reason)
    {
        $this->target   = $target;
        $this->schedule = $schedule;
        $this->reason   = $reason;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Target Savings Debit Failed'
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'target_savings.emails.debit-failed',
            with: [
                'target'   => $this->target,
                'schedule' => $this->schedule,
                'reason'   => $this->reason,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
