<?php

namespace App\Mail;

use App\Models\TargetSavings;
use App\Models\TargetSavingsSchedule;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TargetSavingsScheduleDebited extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public TargetSavings $target;
    public TargetSavingsSchedule $schedule;
    public float $amount;

    public function __construct(TargetSavings $target, TargetSavingsSchedule $schedule, float $amount)
    {
        $this->target   = $target;
        $this->schedule = $schedule;
        $this->amount   = $amount;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Target Savings Debit Successful'
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'target_savings.emails.debit-success',
            with: [
                'target'   => $this->target,
                'schedule' => $this->schedule,
                'amount'   => $this->amount,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
