<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TargetSavingsInterestCredited extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public array $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function envelope(): Envelope
    {
        $suffix = $this->data['date_key'] ?? '';
        return new Envelope(
            subject: 'Target Savings Interest Credited' . ($suffix ? ' — ' . $suffix : '')
        );
    }

    public function content(): Content
    {
        // Light message copy injected into your Blade
        $type = 'Interest Credited';
        $preheader = 'Your target savings just earned daily interest.';

        // NOTE: you said "no condition" for name. Use first + last from caller.
        $msg = sprintf(
            'Hello %s,<br><br>Your target savings has been credited with <strong>₦%s</strong> as daily interest for <strong>%s</strong>.<br><br>Thank you for banking with us.',
            e($this->data['customer_name'] ?? ''),
            e($this->data['interest'] ?? '0.00'),
            e($this->data['date_key'] ?? '')
        );

        return new Content(
            view: 'target_saving.emails.accrued-interest',
            with: [
                'type'      => $type,
                'preheader' => $preheader,
                'msg'       => $msg,
                'data'      => $this->data,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
