<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AppMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $title;
    public $body;
    public $attachment;
    public $attachmentName;

    public function __construct($title, $body, $attachment = null, $attachmentName = null)
    {
        $this->title = $title;
        $this->body  = $body;
        $this->attachment = $attachment;
        $this->attachmentName = $attachmentName;
    }


    public function build()
    {
        $mail = $this->subject($this->title)
            ->view('mails.app-mail', [
                'msg'  => $this->body,
                'type' => $this->title,
            ]);

        if ($this->attachment && $this->attachmentName) {
            $mail->attachData(
                $this->attachment,
                $this->attachmentName,
                ['mime' => 'application/pdf']
            );
        }

        return $mail;
    }
}
