<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use App\Http\Traites\UserTraite;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Traits\SmsTrait;
use App\Services\SmsService; 

class SendSmsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $phone;
    protected $message;
    use UserTraite;


    public function __construct($phone, $message)
    {
        $this->phone = $phone;
        $this->message = $message;
    }

    public function handle()
    {

        $this->sendSms($this->phone, $this->message);
    }
}
