<?php

namespace App\Http\Traites;

use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Setting;
use App\Models\Customer;
use App\Models\NibssLog;
use PragmaRX\Google2FA\Google2FA;
use Illuminate\Support\Facades\DB;
use App\Models\CustomerRestriction;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;

trait UserTraite
{

    function generateUniqueAccountNumber()
    {
        do {
            $accountNumber = '101' . mt_rand(1111111, 9999999);
        } while (Customer::where('acctno', $accountNumber)->exists());

        return $accountNumber;
    }


    public function generatTwofactorcode($userid)
    {
        // dd($userid);
        $user = User::where('id', $userid)->first();

        if (is_null($user->is_2fa_enable)) {

            $getsetvalue = Setting::first();

            $google2fa = new Google2FA(request());
            $secretKey = $google2fa->generateSecretKey();

            $qrCodeUrl = $google2fa->getQRCodeUrl($getsetvalue->getsettingskey('company_name'), $user->email, $secretKey);

            $user->timestamps = false;
            $user->two_factor_code = $secretKey;
            $user->two_factor_expire_at = Carbon::now();
            $user->save();

            session()->put('2FA', [
                'secret' => $secretKey,
                'qrcodeurl' => $qrCodeUrl
            ]);
        }
    }

    public function resetTwoFactorcode($userid)
    {
        $user = User::where('id', $userid)->first();

        $user->timestamps = false;
        $user->two_factor_code = Null;
        $user->two_factor_expire_at = Null;
        $user->save();
    }

    public function sendtwofactormail($code, $fname, $lname, $email)
    {
        $getsetvalue = new Setting();

        Mail::send(['html' => 'mails.sendmail'], [
            'msg' => 'Hi ' . $fname . ' ' . $lname . '<br><br> Your Code is ' . $code . ' please do not share code with anyone only use it on ' . config('name', 'BanqPro') . ' <br><br> these code expires in 5 minutes.',
            'type' => 'Authentication Code'
        ], function ($mail) use ($email, $getsetvalue) {
            $mail->from($getsetvalue->getsettingskey('company_email'), ucwords($getsetvalue->getsettingskey('company_name')));
            $mail->to($email);
            $mail->subject(ucwords($getsetvalue->getsettingskey('company_name')) . ' Two Factor Authentication Code');
        });
    }

    public function logInfo($title = "No Title", $content = '')
    {
        Log::info("*************");
        Log::info($title);
        Log::info("**************************");
        Log::info($content);
    }

    public function sendSms($recipient, $msg)
    {
        $responses = Http::withHeaders([
            "Content-Type" => "application/json"
        ])->post('https://smstrix.paysorta.com/api/sendsms', [
            "api_key" => 'TRIX_G55XAz6biH5stdjlbsqqqGU3dljBe9gJ',
            "api_secret" => 'TRIX_SECRET_m5h9LruoGSxCTPhrmmyP11CdAaI4Dmha',
            "sender" => 'AssetMatrix',
            "phone_number" => $recipient,
            "message" => $msg,
        ]);

        $this->logInfo("Sms Trix sms", $responses);
    }


    // public function sendSms($recipient, $msg, $typ)
    // {
    //     $getsetvalue = new Setting();
    //     $cmpname = ucwords($getsetvalue->getsettingskey('sms_sender'));

    //     if ($getsetvalue->getsettingskey('sms_enabled') == "1") {
    //         if ($typ == "vtpass") {
    //             $responses = Http::withHeaders([
    //                 "Content-Type" => "application/json",
    //                 "X-Token" => $getsetvalue->getsettingskey('sms_public_key'),
    //                 "X-Secret" => $getsetvalue->getsettingskey('sms_secret_key')
    //             ])->get($getsetvalue->getsettingskey('sms_baseurl') . "?sender=" . $cmpname . "&recipient=" . $recipient . "&message=" . $msg . "&responsetype=json");

    //             $this->logInfo("vtpass sms", $responses);

    //         } elseif ($typ == "termii") {

    //             $phone = str_starts_with($recipient, "234") ? $recipient : "234" . substr($recipient, 1);

    //             $responses = Http::withHeaders([
    //                 "Content-Type" => "application/json"
    //             ])->post($getsetvalue->getsettingskey('sms_baseurl') . "sms/send", [
    //                         "api_key" => $getsetvalue->getsettingskey('sms_public_key'),
    //                         "to" => $phone,
    //                         "from" => $cmpname,
    //                         "sms" => $msg,
    //                         "type" => "plain",
    //                         "channel" => "generic"
    //                     ]);

    //             $this->logInfo("termii sms", $responses);
    //         }

    //          elseif ($typ == "sms_trix") {

    //             $phone = str_starts_with($recipient, "234") ? $recipient : "234" . substr($recipient, 1);

    //             $responses = Http::withHeaders([
    //                 "Content-Type" => "application/json"
    //             ])->post($getsetvalue->getsettingskey('sms_baseurl') . "sms/send", [
    //                         "api_key" => $getsetvalue->getsettingskey('sms_public_key'),
    //                         "to" => $phone,
    //                         "from" => $cmpname,
    //                         "sms" => $msg,
    //                         "type" => "plain",
    //                         "channel" => "generic"
    //                     ]);

    //             $this->logInfo("sms trix", $responses);
    //         }
    //     }
    // }

    public function diffbtwdate($start, $end)
    {
        $startdate = Carbon::parse($start);
        $enddate = Carbon::parse($end);

        $nmdays = $startdate->diffInDays($enddate);

        return $nmdays;
    }

    public function CustomerRestrictionNibssLog($cid, ?string $cname, ?string $cacctno, ?string $amount, ?string $ref, ?string $sessionid, ?string $note, ?string $status, ?string $branchid)
    {

        $userCheck = Customer::where('id', $cid)->first();

        if ($userCheck) {

            $reste = CustomerRestriction::create([
                'customer_id' => $cid,
                'customer_name' => $cname,
                'account_number' => $cacctno,
                'reference_no' => $ref,
                'session_id' => $sessionid,
                'amount' => $amount,
                'note' => $note,
                'status' => $status,
                'branch_id' => $branchid
            ]);

            return true;
        } else {
            return ['status' => false, 'message' => "Invalid customer provided"];
        }
    }

    public function checkCustomerRestrictionNibssLog($custid, $status, $branchid)
    {

        $check = CustomerRestriction::where('customer_id', $custid)->where('status', $status)->first();

        if ($check) {
            return true;
        } else {
            return false;
        }
    }

    public function RemoveCustomerRestrictionNibssLog($custid, $status, $tranref, $branchid)
    {

        $userCheck = Customer::where('id', $custid)->first();
        if ($userCheck) {

            $check = CustomerRestriction::where('customer_id', $custid)
                ->where('reference_no', $tranref)
                ->where('status', $status)
                ->first();
            if ($check) {

                $check->delete();

                return ['status' => true, 'message' => "User restriction removed successfully"];
            } else {

                return ['status' => false, 'message' => "No restriction is found on this account"];
            }
        } else {
            return ['status' => false, 'message' => "Invalid Customer provided"];
        }
    }

    public function Nibsslog($cid, ?string $cname, ?string $cacctno, ?string $amount, ?string $ref, ?string $sessionid, ?string $note, ?string $status, ?string $branchid)
    {
        NibssLog::create([
            'customer_id' => $cid,
            'customer_name' => $cname,
            'account_number' => $cacctno,
            'reference_no' => $ref,
            'session_id' => $sessionid,
            'amount' => $amount,
            'note' => $note,
            'type' => $status,
            'branch_id' => $branchid
        ]);
    }

    public function MiddlewareAccountDatails($first_name, $last_name, $bzname, $email, $phone, $addr, $bvn, $acctno, $typ)
    {

        $token = $this->AccessMiddelware();

        $baseurl = env('APP_MODE') == "test" ? env("TEST_ACCESS_URL") : env("LIVE_ACCESS_URL");


        if ($typ == "api") {

            $response = Http::withHeaders([
                "Authorization" => "Bearer " . $token['token'],
                "Content-Type" => "application/json",
                "Accept" => "application/json"
            ])->post($baseurl . "account", [
                "firstname" => $first_name,
                "lastname" => $last_name,
                "email" => $email,
                "phone" => $phone,
                "address" => $addr,
                "account_number" => $acctno,
                "bvn" => $bvn
            ]);

            $this->logInfo("middleware account response via " . $typ, $response);

            if ($response["status"] == true) {
                return [
                    'status' => true,
                    'account_number' => $response["data"]["account_number"],
                    'message' => $response["message"]
                ];
            } else {
                return [
                    'status' => false,
                    'account_number' => "",
                    'message' => $response["message"]
                ];
            }
        } elseif ($typ == "core") {

            $response = Http::withHeaders([
                "Authorization" => "Bearer " . $token['token'],
                "Content-Type" => "application/json",
                "Accept" => "application/json"
            ])->post($baseurl . "account/cba", [
                "firstname" => $first_name,
                "lastname" => $last_name,
                "account_name" => $bzname,
                "email" => $email,
                "phone" => $phone,
                "address" => $addr,
                "account_number" => $acctno,
                "bvn" => $bvn
            ]);

            $this->logInfo("middleware account response via " . $typ, $response);

            if ($response["status"] == true) {
                return [
                    'status' => true,
                    'account_number' => $response["data"]["account_number"],
                    'message' => $response["message"]
                ];
            } else {
                return [
                    'status' => false,
                    'account_number' => "",
                    'message' => $response["message"]
                ];
            }
        }
    }

    public function AccessMiddelware()
    {

        $passwd = env('APP_MODE') == "test" ? env('PASSWORD') : env('LIVE_PASSWORD');

        $baseurl = env('APP_MODE') == "test" ? env("TEST_ACCESS_URL") : env("LIVE_ACCESS_URL");

        $response = Http::withHeaders([
            "Content-Type" => "application/json",
        ])->post($baseurl . "access/token", [
            "email" => env("EMAIL"),
            "password" => $passwd
        ]);

        //return $response;
        $this->logInfo("dw middleware account response", $response);

        if ($response["status"] == true) {
            return ['status' => true, 'token' => $response["data"]["access_token"]];
        } else {
            return ['status' => false, 'token' => ""];
        }
    }

    public function sendMail($msg, ?string $typ, ?string $email, ?string $subject)
    {

        $getsetvalue = new \App\Models\Setting();

        $html = $this->emaildata($msg, $typ, $getsetvalue->getsettingskey('company_logo'));

        Mail::send(['html' => 'mails.sendmail'], [
            'msg' => $html,
            'type' => 'Debit Transaction'
        ], function ($mail) use ($getsetvalue, $email, $subject) {
            $mail->from($getsetvalue->getsettingskey('company_email'), ucwords($getsetvalue->getsettingskey('company_name')));
            $mail->to($email);
            $mail->subject($subject);
        });
    }

    public function emaildata($msg, $type, $logo)
    {



        return '<table style="width: 100%;">
                <tr>
                    <td></td>
                    <td class="header container">

                            <div class="content">
                                <table>
                                <tr>
                                    <td align="center"><img src=' . asset($logo) . ' width="180" /></td>

                                </tr>
                            </table>
                            </div>

                    </td>
                    <td></td>
                </tr>
            </table>
            <table style="width: 100%;">
                <tr>
                    <td></td>
                    <td class="container" style="display:block!important; max-width:600px!important; margin:0 auto!important; clear:both!important;background-color:#FFFFFF">

                        <div style="width: 100%; padding:15px; max-width:600px;margin:0 auto;display:block; ">
                        <table>
                            <tr>
                                <td>

                                    <h3 style="text-align:center">' . $type . '</h3>
                                    <p class="lead" style="margin:3px 0px">
                                        ' . $msg . '
                                    </p>

                                </td>
                            </tr>
                        </table>


                        </div>

                    </td>
                    <td></td>
                </tr>
            </table>';
    }


    private function generateUniqueUsername($firstName, $lastName)
    {
        $base = strtolower(preg_replace('/\s+/', '', $firstName . $lastName));
        $username = $base;
        $counter = 1;
        while (Customer::where('username', $username)->exists()) {
            $username = $base . $counter;
            $counter++;
        }
        return $username;
    }
}//endclass
