<?php

namespace App\Http\Controllers\Api;

use Carbon\Carbon;
use App\Models\Email;
use App\Models\Saving;
use App\Models\Setting;
use App\Models\Customer;
use Illuminate\Http\Request;
use App\Traits\HttpResponses;
use App\Http\Traites\UserTraite;
use App\Http\Traites\SavingTraite;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Traites\LastloginTraite;
use App\Notifications\AppNotification;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Notification;

class LoginController extends Controller
{
    use LastloginTraite;
    use SavingTraite;
    use UserTraite;
    use HttpResponses;

    // public function login(Request $r)
    // {
    //     $this->logInfo("customer login", $r->except('password'));

    //     $validate = Validator::make($r->all(), [
    //         'username' => ['required', 'string'],
    //         'password' => ['required', 'string'],
    //         'device_id' => ['required', 'string'],
    //     ]);

    //     if ($validate->fails()) {
    //         return $this->error(
    //             'Validation error.',
    //             422,
    //             $validate->errors()->toArray()
    //         );
    //     }

    //     $deviceid   = $r->device_id ?? 'web';
    //     $devicetype = $deviceid === "web" ? "web" : "mobile";

    //     return $user = Customer::where('username', $r->username)->first();

    //     if (! $user) {
    //         return $this->error('Invalid login credentials.', 401);
    //     }

    //     switch ($user->status) {
    //         case "6":
    //             return $this->error('Your account has been blocked. Please contact support.', 401);
    //         case "5":
    //             return $this->error('Your account has been blocked due to a fraudulent attack. Please contact support or visit any of our branches.', 401);
    //         case "4":
    //             return $this->error('Your account has been restricted. Please contact support.', 401);
    //         case "2":
    //             return $this->error('Your account has been closed. Please contact support.', 401);
    //         case "8":
    //             return $this->error('Your account is dormant or inactive. Please contact support or visit any of our branches.', 401);
    //         case "7":
    //             return $this->error('Your account is currently being reviewed and will be approved soon.', 401);
    //         case "9":
    //             return $this->error('This account does not exist.', 401);
    //     }

    //     $getsetvalue = new Setting();

    //     if (Auth::guard('customer')->attempt([
    //         'username' => $r->username,
    //         'password' => $r->password
    //     ])) {
    //         /** @var \App\Models\Customer $authUser */
    //         $authUser = Auth::guard('customer')->user();

    //         if ($authUser->phone_verify == 1) {
    //             // reset failed counters
    //             $authUser->failed_logins  = null;
    //             $authUser->failed_balance = null;
    //             $authUser->failed_pin     = null;
    //             $authUser->last_login     = Carbon::now();
    //             $authUser->save();

    //             $savings = Saving::where('customer_id', $authUser->id)->first();

    //             $userDetails = [
    //                 "userid"     => $authUser->id,
    //                 "first_name" => $authUser->first_name,
    //                 "last_name"  => $authUser->last_name,
    //                 "phone"      => $authUser->phone,
    //                 "profilepic" => url('/') . "/" . $authUser->photo,
    //                 "username"   => $authUser->username,
    //                 "bvn"        => $authUser->bvn,
    //                 "nin"        => $authUser->nin,
    //                 "email"      => $authUser->email,
    //                 "address"    => $authUser->address,
    //                 "sex"        => $authUser->sex,
    //                 "accountno"  => $authUser->acctno,
    //                 "balance"    => $savings ? $savings->account_balance : 0,
    //                 "currency"   => $getsetvalue->getsettingskey('currency_symbol'),
    //             ];

    //             $deviceCheck = $this->CheckDeviceId($devicetype, $deviceid, $authUser->id);

    //             if ($deviceCheck['status'] === false) {
    //                 return $this->error($deviceCheck['message'] ?? ' this device is not linked to this account');
    //             }

    //             $this->logInfo("device response", $deviceCheck);

    //             $deviceTokenCheck = $this->CheckDeviceToken($r->device_token, $authUser->id);

    //             if (method_exists($authUser, 'tokens')) {
    //                 $authUser->tokens()->delete();
    //             }

    //             $accessToken = $authUser->createToken(
    //                 'customerToken',
    //                 ['customer'],
    //                 Carbon::now()->addMinutes(20)
    //             );

    //             return $this->success(
    //                 'Login successfully.',
    //                 [
    //                     'user'         => $userDetails,
    //                     'access_token' => $accessToken->plainTextToken,
    //                     'expired_at'   => date(
    //                         'Y-m-d H:i:s',
    //                         strtotime($accessToken->accessToken->expires_at)
    //                     ),
    //                 ],
    //                 // '000',
    //                 // 201
    //             );

    //             // return $this->success('Login successfully.', [
    //             //     'user'         => $userDetails,
    //             //     'access_token' => $accessToken->plainTextToken,
    //             //     'expired_at'   => date('Y-m-d H:i:s', strtotime($accessToken->accessToken->expires_at)),
    //             // ]);

    //         } else {
    //             $otpCode = $this->generateSixOTP();

    //             $authUser->otp                 = $otpCode;
    //             $authUser->otp_expiration_date = Carbon::now()->addMinutes(5);
    //             $authUser->save();

    //             $msg = "You requested an OTP: " . $otpCode . "<br> Do not share with anyone.";

    //             Email::create([
    //                 'user_id'   => $authUser->id,
    //                 'subject'   => ucwords($getsetvalue->getsettingskey('company_name')) . " OTP Confirmation",
    //                 'message'   => $msg,
    //                 'recipient' => $authUser->email,
    //             ]);

    //             Notification::route('mail', $authUser->email)
    //                 ->notify(new AppNotification('AssetMatrix MFB OTP Confirmation', $msg));

    //             return $this->error(
    //                 'Account pending verification.',
    //                 203,
    //                 [
    //                     'userid' => $authUser->id,
    //                     'email'  => $authUser->email,
    //                 ]
    //             );
    //         }
    //     } else {

    //         $user->failed_logins = $user->failed_logins ?? 0;

    //         if ($user->failed_logins >= 3) {
    //             $user->status = 6;
    //             $user->save();

    //             return $this->error(
    //                 'Your account has been blocked. Please contact admin to unlock your account.',
    //                 401
    //             );
    //         } else {
    //             $user->failed_logins += 1;
    //             $user->save();

    //             return $this->error(
    //                 'Invalid login credentials. Your account will be deactivated after ' . (4 - $user->failed_logins) . ' more attempt(s).',
    //                 401
    //             );
    //         }
    //     }
    // }


    public function login(Request $request)
    {
        // Log login attempt (never log password)
        $this->logInfo('Customer login attempt', $request->except('password'));


        $validator = Validator::make($request->all(), [
            'username'      => ['required', 'string'],
            'password'      => ['required', 'string'],
            'device_id'     => ['required', 'string'],
            'device_token'  => ['nullable', 'string'],
        ]);

        if ($validator->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validator->errors()->toArray()
            );
        }


        $deviceId   = $request->device_id;
        $deviceType = $deviceId === 'web' ? 'web' : 'mobile';


        $user = Customer::where('username', $request->username)->first();

        if (!$user) {
            return $this->error('Invalid login credentials.', 401);
        }


        switch ((string) $user->status) {
            case '6':
                return $this->error('Your account has been blocked. Please contact support.', 401);
            case '5':
                return $this->error('Your account has been blocked due to suspicious activity.', 401);
            case '4':
                return $this->error('Your account has been restricted. Please contact support.', 401);
            case '2':
                return $this->error('Your account has been closed. Please contact support.', 401);
            case '8':
                return $this->error('Your account is dormant. Please contact support.', 401);
            case '7':
                return $this->error('Your account is under review.', 401);
            case '9':
                return $this->error('This account does not exist.', 401);
        }


        if (!Hash::check($request->password, $user->password)) {

            // Increment failed login count
            $user->failed_logins = ($user->failed_logins ?? 0) + 1;

            // Auto-block after 3 failures
            if ($user->failed_logins >= 3) {
                $user->status = 6; // blocked
            }

            $user->save();

            return $this->error(
                'Invalid login credentials. Your account will be blocked after '
                    . (3 - ($user->failed_logins ?? 0)) . ' more attempt(s).',
                401
            );
        }


        $user->update([
            'failed_logins'  => null,
            'failed_balance' => null,
            'failed_pin'     => null,
            'last_login'     => Carbon::now(),
        ]);


        if ($user->phone_verify != 1) {

            // Generate OTP
            $otp = $this->generateSixOTP();

            $user->update([
                'otp' => $otp,
                'otp_expiration_date' => Carbon::now()->addMinutes(5),
            ]);

            return $this->error(
                'Account pending verification.',
                203,
                [
                    'userid' => $user->id,
                    'email'  => $user->email,
                ]
            );
        }


        $deviceCheck = $this->CheckDeviceId($deviceType, $deviceId, $user->id);

        if ($deviceCheck['status'] === false) {
            return $this->error(
                $deviceCheck['message'] ?? 'This device is not linked to this account',
                401
            );
        }

        $this->CheckDeviceToken($request->device_token, $user->id);

        $user->tokens()->delete();
        $token = $user->createToken(
            'customerToken',
            ['customer'],
            Carbon::now()->addMinutes(20)
        );
        $savings = Saving::where('customer_id', $user->id)->first();
        $userDetails = [
            'userid'     => $user->id,
            'first_name' => $user->first_name,
            'last_name'  => $user->last_name,
            'phone'      => $user->phone,
            'username'   => $user->username,
            'email'      => $user->email,
            'account_number'  => $user->acctno,
            'account_balance'    => $savings?->account_balance ?? 0,
        ];

        return $this->success(
            'Login successful.',
            [
                'user'         => $userDetails,
                'access_token' => $token->plainTextToken,
                'expired_at'   => $token->accessToken->expires_at,
            ]
        );
    }


    public function CheckDeviceId($devicetype, $deviceid, $userid)
    {
        $customer = Customer::select('id', 'device_id', 'internet_banking')
            ->where('id', $userid)
            ->first();

        // WEB LOGIN
        if ($devicetype === "web") {

            if ($customer->internet_banking == 1) {
                return [
                    'status'  => true,
                    'code'    => 200,
                    'message' => 'Internet banking enabled',
                ];
            }

            return [
                'status'  => false,
                'code'    => 403,
                'message' => 'Internet banking is not enabled for this account, kindly contact support',
            ];
        }

        if ($customer->device_id === $deviceid) {
            return [
                'status'  => true,
                'code'    => 200,
                'message' => 'Device Ok',
            ];
        }

        return [
            'status'  => false,
            'code'    => 403,
            'message' => 'Sorry, this device is not linked to this account',
        ];
    }


    public function CheckDeviceToken($deviceToken, $userid)
    {
        $user = Customer::where('id', $userid)->first();

        if (is_null($user->device_token)) {
            $uspdt              = Customer::where('id', $userid)->first();
            $uspdt->device_token = $deviceToken;
            $uspdt->save();


            return [
                'status'      => true,
                'message'     => 'Device token linked',
                'code'        => '104',
                'deviceToken' => $deviceToken,
            ];
        } else {
            $deeid = $deviceToken;

            if ($user->device_token == $deeid) {
                return [
                    'status'      => true,
                    'message'     => 'Device token OK',
                    'deviceToken' => $user->device_token,
                    'code'        => '104',
                ];
            } else {
                return [
                    'status'  => false,
                    'message' => 'Sorry, this is an invalid device token',
                    'userid'  => $user->id,
                    'code'    => '105',
                ];
            }
        }
    }

    public function logout_customer(Request $request)
    {
        return Auth::user();
        return Auth::guard('customer')->logout();
        Auth::user()->currentAccessToken()->delete();
        return $this->success('Logout successful.', null, '00', 201);
    }
}
