<?php

namespace App\Http\Controllers\Api;

use Exception;
use Carbon\Carbon;
use App\Models\Email;
use App\Models\Saving;
use App\Models\Setting;
use App\Models\Customer;
use Mockery\Expectation;
use App\Models\Beneficiary;
use Illuminate\Support\Str;
use App\Models\FixedDeposit;
use Illuminate\Http\Request;
use App\Models\GeneralLedger;
use App\Traits\HttpResponses;
use App\Models\Ipwhitelisting;
use App\Http\Traites\UserTraite;
use App\Http\Traites\AuditTraite;
use App\Models\PhoneVerification;
use App\Http\Traites\SavingTraite;
use App\Models\SavingsTransaction;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Cache;
use App\Notifications\AppNotification;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Notification;

class CustomersController extends Controller
{
    use SavingTraite;
    use AuditTraite;
    use UserTraite;
    use HttpResponses;

    public $bearertoken;

    public function verifyBvn(Request $request)
    {

        $validation = Validator::make($request->all(), [
            'bvn' => ['required', 'numeric', 'digits:10'],
        ]);

        if ($validation->fails()) {
            return $this->error('Validation error.', 422, $validation->errors()->toArray());
        }
        if ($request->bvn == "1234567890") {

            $firstNames = ['Michael', 'Aisha', 'Chinedu', 'Fatima', 'Emeka', 'Grace', 'Sule', 'Rita', 'Ibrahim', 'Opeyemi'];
            $lastNames  = ['Okon', 'Danladi', 'Eze', 'Suleiman', 'Adewale', 'Bassey', 'Yusuf', 'Ojo', 'Nwachukwu', 'Balogun'];
            $genders  = ['Male', 'Female','Male', 'Female'];

            $first = $firstNames[array_rand($firstNames)];
            $last  = $lastNames[array_rand($lastNames)];
            $gender  = $genders[array_rand($genders)];

            $dob = Carbon::create(rand(1980, 2002), rand(1, 12), rand(1, 28))->format('d-M-Y');

            return $this->success('BVN Verified Successfully', [
                'first_name' => $first,
                'last_name'  => $last,
                'dob'        => $dob,
                'bvn'        => $request->bvn,
                'gender'     => $gender
            ]);
        } else {
            return $this->error('BVN not verified.');
        }
    }

    public function get_customers_details()
    {
        $this->logInfo("", "get user details");
        try {
            $getsetvalue = new Setting();
            $location = 'uploads';

            $fixeddeposit = [];

         
            $user = Auth::user();

            $savings = Saving::where('customer_id', $user->id)->first();

            $fixdposits = FixedDeposit::where('customer_id', $user->id)->get();
            foreach ($fixdposits as $fixdpo) {
                $interestm = str_replace("_", " ", $fixdpo->interest_method);
                array_push($fixeddeposit, ["fd_code" => $fixdpo->fixed_deposit_code, "principal" => $fixdpo->principal, "release_date" => $fixdpo->release_date, "maturity_date" => $fixdpo->maturity_date, "interest_method" => $interestm, "interest_rate" => $fixdpo->interest_rate]);
            }

            $creditcount = SavingsTransaction::whereIn('type', ['deposit', 'credit', 'fixed_deposit', 'loan', 'fd_interest', 'rev_withdrawal'])
                ->where('status', 'approved')
                ->where('customer_id', $user->id)
                ->sum('amount');

            $debitcount = SavingsTransaction::whereIn('type', ['withdrawal', 'debit', 'rev_deposit'])
                ->where('status', 'approved')
                ->where('customer_id', $user->id)
                ->sum('amount');

            $userDetails = [
                "uuid" => "",
                "userid" => $user->id,
                "first_name" => !is_null($user->business_name) ? ucwords($user->business_name) : $user->first_name,
                "last_name" => !is_null($user->business_name) ? "" : $user->last_name,
                "business_name" => !is_null($user->business_name) ? ucwords($user->business_name) : null,
                "dob" => $user->dob,
                "phone" => $user->phone,
                "profilepic" => url('/') . "/" . $user->photo,
                "username" => $user->username,
                "bvn" => $user->bvn,
                "nin" => $user->nin,
                "email" => $user->email,
                "address" => $user->residential_address,
                "sex" => $user->gender,
                "referral" => $user->referral_code,
                "valid_id" => url('/') . "/" . $user->upload_id,
                "signature" => url('/') . "/" . $user->signature,
                "accountno" => $user->acctno,
                "balance" => $savings->account_balance,
                "currency" => $getsetvalue->getsettingskey('currency_symbol'),
                "fixeddeposit" => $fixeddeposit,
                "Creditbalance" => !empty($creditcount) ? $creditcount : 0,
                "Debitbalance" => !empty($debitcount) ? $debitcount : 0
            ];

            return $this->success('Customers Details Fetched successfully', $userDetails);
            //    return response()->json(['status' => true, 'message' => 'Customers Details Fetched successfully', 'data' => $userDetails]);

        } catch (Exception $e) {
            return $this->error('Customers Details Fetched successfully', $e->getMessage());

            // return response()->json(['status' => false, 'message' => $e->getMessage(), 'data' => []], 500);
        }
    }

    public function getBalance()
    {
        $lock = Cache::lock('getbl', 2);
        if ($lock->get()) {

            $user = Auth::user();
            $savings = Saving::select('account_balance')->where('customer_id', $user->id)->first();

            $creditcount = SavingsTransaction::where('status', 'approved')
                ->where('customer_id', $user->id)
                ->whereIn('type', ['deposit', 'credit', 'fixed_deposit', 'loan', 'fd_interest', 'rev_withdrawal'])
                ->sum('amount');

            $debitcount = SavingsTransaction::where('status', 'approved')
                ->where('customer_id', $user->id)
                ->whereIn('type', ['withdrawal', 'debit', 'rev_deposit'])
                ->sum('amount');

            $bal = $savings ? $savings->account_balance : 0;
            $creditbalance = !empty($creditcount) ? $creditcount : 0;
            $debitbalance = !empty($debitcount) ? $debitcount : 0;

            return $this->success('Balance fetch successfully', [
                'balance' => $bal,
                'credit' => $creditbalance,
                'debit' => $debitbalance,

            ]);
            $lock->release();
        }
    }


    public function getTransactions()
    {
        $user = Auth::user();
        $lock = Cache::lock('gettranx', 2);
        $lockAcquired = $lock->get();

        $query = SavingsTransaction::select('amount', 'type', 'reference_no', 'notes', 'status', 'trnx_type', 'created_at')
            ->where('customer_id', $user->id)
            ->orderBy('id', 'DESC');

        if (request()->has('perpage')) {
            $perpage = (int) request()->perpage;
            $transactions = $query->take($perpage)->get();
        } else {
            $transactions = $query->get();
        }

        if ($lockAcquired) {
            $lock->release();
        }

        if ($transactions->isEmpty()) {
            return $this->error('No transactions found.', 404);
        }

        return $this->success('Transactions fetched successfully', [
            'allTrans' => $transactions,
        ]);
    }


    public function verify_otp(Request $r)
    {
        $this->logInfo("verifying otp", $r->all());

        $validate = Validator::make($r->all(), [
            'otp_code' => ['required', 'digits_between:4,6'],
            'email'    => ['required', 'email'],
        ]);

        if ($validate->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validate->errors()->toArray()
            );
        }

        $customer = Customer::where('email', $r->email)->first();

        if (!$customer || $customer->otp !== $r->otp_code) {
            return $this->error('Invalid OTP', 400);
        }

        if (empty($customer->otp_expiration_date) || $customer->otp_expiration_date <= Carbon::now()) {
            return $this->error('OTP expired', 400);
        }
        $customer->phone_verify         = 1;
        $customer->save();

        $usern = $customer->last_name . " " . $customer->first_name;
        $this->tracktrails('1', '1', $usern, 'customer', 'OTP verification');

        return $this->success('OTP verified successfully');
    }

    // Comming back to this
    public function confirm_otp(Request $request)
    {
        $this->logInfo("confirming otp", $request->all());

        $validate = Validator::make($request->all(), [
            'otp' => ['required', 'digits:6'],
            'email' => ['required', 'email']
        ]);

        if ($validate->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validate->errors()->toArray()
            );
        }

        $customer = Customer::where('email', $request->email)
            ->first();

        if (!$customer) {
            return $this->error('Invalid Customer credentials');
        }
        if ($customer->otp !== $request->otp) {
            return $this->error('Invalid OTP');
        }

        if ($customer->otp_expiration_date <= Carbon::now()) {
            return $this->error('OTP Expired');
        }

        if (!empty($request->account_exist) && $request->account_exist == "1") {

            $username = ltrim($customer->phone, '0');
            $password = (string) mt_rand(11111111, 99999999);
            $pin = (string) mt_rand(1111, 9999);

            $customer->status = "1";
            $customer->phone_verify = "1";
            $customer->username = $username;
            $customer->password = Hash::make($password);
            $customer->pin = Hash::make($pin);
            $customer->save();

            $name = $customer->business_name
                ?? ($customer->last_name . " " . $customer->first_name);

            $msg = "Welcome {$name}. Your login credentials are:<br>
        Username: {$username}<br>
        Password: {$password}<br>
        Transaction Pin: {$pin}<br>
        Account Number: {$customer->acctno}<br><br>
        Kindly reset your password after login from the settings page.";

            Email::create([
                'user_id' => $customer->id,
                'subject' => "Online Banking Login Credentials",
                'message' => $msg,
                'recipient' => $customer->email,
            ]);

            Notification::route('mail', $customer->email)
                ->notify(new AppNotification('Online Banking Login Credential', $msg));
        } else {
            $customer->phone_verify = "1";
            $customer->status = "1";
            $customer->save();
        }
        $fullName = trim($customer->last_name . " " . $customer->first_name);
        $this->tracktrails($customer->id, '1', $fullName, 'customer', 'OTP Confirmation');

        return $this->success('OTP Confirmed Successfully');
    }

    public function forgetpassword(Request $r)
    {
        $this->logInfo("forget password", $r->all());

        $validate = Validator::make($r->all(), [
            'email' => ['required', 'string', 'email']
        ]);

        if ($validate->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validate->errors()->toArray()
            );
        }

        $getsetvalue = new Setting();

        $otpCode = $this->generateSixOTP();

        $chkemail = Customer::where('email', $r->email)->first();

        if (!empty($chkemail)) {

            $chkemail->otp = $otpCode;
            $chkemail->otp_expiration_date = Carbon::now()->addMinutes(10);
            $chkemail->failed_logins = 0;
            $chkemail->save();


            $name = !is_null($chkemail->business_name) ? $chkemail->business_name : $chkemail->last_name . " " . $chkemail->first_name;

            $smsmsg = "OTP Code:" . $otpCode;
            $this->sendSms($chkemail->phone, $smsmsg, $getsetvalue->getsettingskey('active_sms')); //send sms

            Email::create([
                'user_id' => $chkemail->id,
                'subject' => "forget Password",
                'message' => "Hi " . $name . "<br><br> Below is your OTP: " . $otpCode,
                'recipient' => $r->email,
            ]);

            $msg = "Dear, " . $name . ",<br><br> Below is your OTP: " . $otpCode . " <br><br>Kindly upload your Valid ID and link BVN.";


            Notification::route('mail', $r->email)
                ->notify(new AppNotification('Forget Password', $msg));

            $usern = $chkemail->last_name . " " . $chkemail->first_name;
            $this->tracktrails('1', '1', $usern, 'customer', 'OTP Sent Successfully to ' . $r->email);

            return $this->success('OTP Sent Successfully');
        } else {
            return $this->error('Email is not linked to this account, please contact support', 400);
        }
    }

    public function resend_otp(Request $r)
    {

        $this->logInfo("otp resent", $r->all());

        $validate = Validator::make($r->all(), [
            'email' => ['required', 'string', 'email']
        ]);

        if ($validate->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validate->errors()->toArray()
            );
        }

        $getsetvalue = new Setting();

        $otpCode = $this->generateSixOTP();

        $chkemail = Customer::where('email', $r->email)->first();

        if (!empty($chkemail)) {

            $chkemail->otp = $otpCode;
            $chkemail->otp_expiration_date = Carbon::now()->addMinutes(10);
            $chkemail->failed_logins = 0;
            $chkemail->save();

            $name = !is_null($chkemail->business_name) ? $chkemail->business_name : $chkemail->last_name . " " . $chkemail->first_name;

            $smsmsg = "OTP Code:" . $otpCode;
            $this->sendSms($chkemail->phone, $smsmsg, $getsetvalue->getsettingskey('active_sms')); //send sms

            Email::create([
                'user_id' => $chkemail->id,
                'subject' => "OTP Confirmation",
                'message' => "Hi " . $name . "<br><br> Below is your OTP: " . $otpCode,
                'recipient' => $r->email,
            ]);

            $msg = "Dear, " . $name . "<br><br> Below is your OTP: " . $otpCode . " <br><br>Kindly upload your Valid ID and link BVN.";
            Notification::route('mail', $r->email)
                ->notify(new AppNotification('OTP Confirmation', $msg));

            $usern = $chkemail->last_name . " " . $chkemail->first_name;
            $this->tracktrails('1', '1', $usern, 'customer', 'OTP Resent Successfully to ' . $r->email);

            return $this->success('OTP Sent Successfully');
        } else {
            return $this->error('Email is not linked to this account, please contact support');
        }
    }

    public function reset_password(Request $r)
    {
        $this->logInfo("password reset request", $r->all());

        $validator = Validator::make($r->all(), [
            'email' => ['required', 'email'],
            'otp_code' => ['required', 'numeric'],
            'password' => ['required', 'string', 'min:8'],
        ]);

        if ($validator->fails()) {
            return $this->error('Validation error.', 422, $validator->errors()->toArray());
        }

        $customer = Customer::where('email', $r->email)
            ->first();

        if (!$customer) {
            return $this->error('Invalid credentials.', 422);
        }

        if ($customer->otp !== $r->otp_code) {
            return $this->error('Invalid OTP.', 422);
        }

        if (!empty($customer->otp_expiration_date) && Carbon::parse($customer->otp_expiration_date)->lte(Carbon::now())) {
            return $this->error('OTP expired.', 422);
        }

        $customer->password = Hash::make($r->password);
        $customer->otp = null;
        $customer->otp_expiration_date = null;
        $customer->failed_logins = null;
        $customer->save();

        $usern = trim(($customer->last_name ?? '') . ' ' . ($customer->first_name ?? ''));
        $this->tracktrails($customer->id, '1', $usern, 'customer', 'Password Reset Successfully');

        $msg = "Dear {$usern},<br><br>Your password was successfully changed. If you did not perform this action, contact support immediately.";

        Email::create([
            'user_id' => $customer->id,
            'subject' => 'Password Changed',
            'message' => $msg,
            'recipient' => $customer->email,
        ]);

        Notification::route('mail', $customer->email)
            ->notify(new AppNotification('Password Changed', $msg));

        return $this->success('Password reset successfully.');
    }


    public function change_password(Request $r)
    {
        $validator = Validator::make($r->all(), [
            'current_password' => ['required', 'string'],
            'new_password' => ['required', 'string', 'min:8'],
        ]);

        if ($validator->fails()) {
            return $this->error('Validation error.', 422, $validator->errors()->toArray());
        }

        $customer = Customer::find(Auth::id());

        if (! $customer) {
            return $this->error('User not found.', 404);
        }

        if (! Hash::check($r->input('current_password'), $customer->password)) {

            return $this->error('Invalid current password provided.', 422);
        }

        if (Hash::check($r->input('new_password'), $customer->password)) {
            return $this->error('New password must be different from the current password.', 422);
        }

        $customer->password = Hash::make($r->input('new_password'));
        $customer->save();

        $msg = "Dear " . ucfirst($customer->first_name) . ",<br><br>
        Your account password has been successfully updated.<br><br>
        If you did not authorize this change, please contact our support team immediately as this may indicate unauthorized access to your account.<br><br>
        Thank you,<br>
        Asset Matrix Support Team";

        Notification::route('mail', $customer->email)
            ->notify(new AppNotification('Account Registration', $msg));


        $usern = trim(($customer->last_name ?? '') . ' ' . ($customer->first_name ?? ''));
        $this->tracktrails($customer->id, '1', $usern, 'customer', 'Password Changed Successfully');

        return $this->success('Password changed successfully.');
    }

    public function reset_pin(Request $r)
    {
        $validator = Validator::make($r->all(), [
            'current_pin' => ['required', 'digits:4'],
            'new_pin' => ['required', 'digits:4'],
        ]);

        if ($validator->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validator->errors()->toArray()
            );
        }

        $customer = Customer::find(Auth::id());

        if (! $customer) {
            return $this->error('Customer not found.', 404);
        }

        if ($r->new_pin == $r->current_pin) {
            return $this->error('New PIN cannot be the same as the current PIN.', 422);
        }

        if (!Hash::check($r->current_pin, $customer->pin)) {
            return $this->error('Invalid current PIN.', 422);
        }

        $customer->pin = Hash::make($r->new_pin);
        $customer->save();

        $usern = trim(($customer->last_name ?? '') . ' ' . ($customer->first_name ?? ''));
        $this->tracktrails($customer->id, '1', $usern, 'customer', 'PIN Reset Successfully');

        return $this->success('PIN reset successfully.');
    }

    public function update_profile(Request $r)
    {
        $this->logInfo("profile update log", $r->all());

        $validator = Validator::make($r->all(), [
            'phone_number' => ['required', 'numeric'],
            'email' => ['required', 'email'],
            'dob' => ['required', 'string'],
            'gender' => ['nullable', 'string'],
            'address' => ['nullable', 'string'],
            'bvn' => ['nullable', 'string'],
            'nin' => ['nullable', 'string'],
        ]);

        if ($validator->fails()) {
            return $this->error(
                'Validation error.',
                422,
                $validator->errors()->toArray()
            );
        }

        $user = Customer::find(Auth::id());

        if (! $user) {
            return $this->error('User not found.', 404);
        }

        $user->phone = $r->phone_number;
        $user->email = $r->email;
        $user->dob = date("Y-m-d", strtotime($r->dob));
        $user->gender = $r->gender;
        $user->residential_address = $r->address;
        $user->bvn = $r->bvn;
        $user->nin = $r->nin;
        $user->save();

        $usern = trim(($user->last_name ?? '') . ' ' . ($user->first_name ?? ''));
        $this->tracktrails($user->id, '1', $usern, 'customer', 'Profile Updated Successfully');

        return $this->success('Profile updated successfully.', $user);
    }


    public function uploadFile(Request $request)
    {
        $this->logInfo("file upload request log", $request->all());

        $validator = Validator::make($request->all(), [
            'image_file' => 'required|mimes:jpg,jpeg,png|max:5512',
            'type' => 'required|in:passport,valid_id,signature',
        ]);

        if ($validator->fails()) {
            return $this->error('Validation error.', 422, $validator->errors()->toArray());
        }

        $user = Customer::find(Auth::id());

        if (! $user) {
            return $this->error('User not found.', 404);
        }

        if (! $request->hasFile('image_file')) {
            return $this->error('No file uploaded.', 422);
        }

        $file = $request->file('image_file');
        $pathLocation = 'uploads';
        $newName = time() . '_' . $file->getClientOriginalName();

        $file->move(public_path($pathLocation), $newName);
        $filePath = $pathLocation . '/' . $newName;

        if ($request->type === 'passport') {
            $user->photo = $filePath;
        } elseif ($request->type === 'valid_id') {
            $user->upload_id = $filePath;
        } elseif ($request->type === 'signature') {
            $user->signature = $filePath;
        }

        $user->save();

        $usern = trim(($user->last_name ?? '') . ' ' . ($user->first_name ?? ''));
        $this->tracktrails($user->id, '1', $usern, 'customer', 'File Upload Successfully');

        return $this->success($request->type . ' upload successful.', ['type' => $request->type, 'path' => $filePath]);
    }

    public function getbeneficiary()
    {
        $customerId = Auth::id();

        $bankBeneficiaries = Beneficiary::where('customer_id', $customerId)
            ->where('type', 'bank')
            ->get();

        $walletBeneficiaries = Beneficiary::where('customer_id', $customerId)
            ->where('type', 'wallet')
            ->get();

        if ($bankBeneficiaries->isNotEmpty() || $walletBeneficiaries->isNotEmpty()) {
            return $this->success('Beneficiary list retrieved successfully.', [
                'bankdata' => $bankBeneficiaries,
                'walletdata' => $walletBeneficiaries
            ]);
        }

        return $this->error('No saved beneficiary found.', 404);
    }


    public function sendLinkDeviceOtp(Request $request)
    {
        $getsetvalue = new Setting();

        $this->logInfo("send link device Otp request log", $request->all());

        $validate = Validator::make($request->all(), [
            'uid' => 'required',
            'numeric',
        ]);

        if ($validate->fails()) {
            $ra = array("status" => false, "message" => $validate->errors()->all()[0]);
            return response()->json($ra, 406);
        }

        $userAccunt = Customer::where('id', $request->uid)->first();

        if ($userAccunt) {

            $otpCode = $request->uid == '1' ? '3565' : $this->generateOTP();

            $userAccunt->otp = $otpCode;
            $date = Carbon::now()->addMinutes(10)->format('Y-m-d H:i:s');

            $userAccunt->otp_expiration_date = $date;
            $userAccunt->save();

            $useremail = Customer::select('id', 'email', 'phone')->where('id', $request->uid)->first();

            $msg = "Your OTP has been sent to ur email for device linkage " . $otpCode . " Do not share with anyone.";

            Email::create([
                'user_id' => $useremail->id,
                'subject' => ucwords($getsetvalue->getsettingskey('company_name')) . " New Device OTP",
                'message' => $msg,
                'recipient' => $useremail->email,
            ]);

            $this->sendMail($msg, 'OTP Confirmation', $useremail->email, "New Device OTP");

            //    Mail::send(['html' => 'mails.sendmail'],[
            //        'msg' => $msg,
            //        'type' => "OTP Confirmation"
            //    ],function($mail)use($getsetvalue,$useremail){
            //        $mail->from($getsetvalue->getsettingskey('company_email'),ucwords($getsetvalue->getsettingskey('company_name')));
            //         $mail->to($useremail->email);
            //        $mail->subject("New Device OTP");
            //    });

            return response(['status' => true, 'message' => 'OTP Sent Successfully', 'uid' => $request->uid]);
        } else {
            return response()->json(['status' => false, 'message' => 'Invalid account'], 400);
        }
    }

    public function resendLinkDeviceOtp(Request $request)
    {

        $this->logInfo("resendOtp request log", $request->all());

        $validate = Validator::make($request->all(), [
            'uid' => 'required',
            'numeric',
        ]);

        if ($validate->fails()) {
            $ra = array("status" => false, "message" => $validate->errors()->all()[0]);
            return response()->json($ra, 406);
        }

        $getsetvalue = new Setting();

        $userAccunt = Customer::where('id', $request->uid)->first();

        if ($userAccunt) {

            $otpCode = $request->uid == '1' ? '3565' : $this->generateOTP();
            $date = Carbon::now()->addMinutes(10)->format('Y-m-d H:i:s');

            $userAccunt->otp = $otpCode;
            $userAccunt->otp_expiration_date = $date;
            $userAccunt->save();

            $useremail = Customer::select('id', 'email', 'phone')->where('id', $request->uid)->first();

            $msg = "Your OTP for device linkage " . $otpCode . " Do not share with anyone.";

            Email::create([
                'user_id' => $useremail->id,
                'subject' => ucwords($getsetvalue->getsettingskey('company_name')) . " OTP for device linkage",
                'message' => $msg,
                'recipient' => $useremail->email,
            ]);

            $this->sendMail($msg, 'OTP Confirmation', $useremail->email, "New Device OTP");

            //    Mail::send(['html' => 'mails.sendmail'],[
            //        'msg' => $msg,
            //        'type' => "OTP Confirmation"
            //    ],function($mail)use($getsetvalue,$useremail){
            //        $mail->from($getsetvalue->getsettingskey('company_email'),ucwords($getsetvalue->getsettingskey('company_name')));
            //         $mail->to($useremail->email);
            //        $mail->subject("New Device OTP");
            //    });

            return response(['status' => true, 'message' => 'OTP Sent Successfully', 'uid' => $request->uid]);
        } else {
            return response()->json(['status' => false, 'message' => 'Invalid account'], 400);
        }
    }

    public function verifyLinkDeviceOTP(Request $request)
    {

        $this->logInfo($request->all(), "verifyOTP request log");

        $validate = Validator::make($request->all(), [
            'uid' => 'required|numeric',
            'otp_code' => 'required|numeric|gt:0',
        ]);

        if ($validate->fails()) {
            $ra = array("status" => false, "message" => $validate->errors()->all()[0]);
            return response()->json($ra, 406);
        }

        $deviceid = !empty($request->header('device_id')) ? $request->header('device_id') : $request->device_id;

        $userAccunt = Customer::where('id', $request->uid)->where('otp', $request->otp_code)->first();

        if ($userAccunt) {

            if ($userAccunt->otp_expiration_date > Carbon::now()) {

                $otpcode = $request->uid == '1' ? '3565' : mt_rand("111111", "999999");

                $userAccunt->otp = $otpcode;
                $userAccunt->device_id = $deviceid . "_" . $request->uid;
                $userAccunt->save();


                return response(['status' => true, 'message' => 'Device Linked Successfully']);
            } else {
                return response(['status' => false, 'message' => 'You OTP has Expired']);
            }
        } else {
            return response(['status' => false, 'message' => "Invalid OTP supplied"]);
        }
    }

    //verifyme nin verification
    public function VerifyCustomeNiN(Request $request)
    {

        $lock = Cache::lock('vrinin', 2);

        if ($lock->get()) {


            $ClientIp = !empty($request->header('ipaddr')) ? $request->header('ipaddr') : $request->ipaddr;

            $dvtyp = $request->deviceType == "web" ? "web- " . $ClientIp : "mobile- " . $ClientIp;

            $this->logInfo($request->all(), "Verify nin log api route " . $request->getClientIp() . " " . $dvtyp);

            $validation = Validator::make($request->all(), [
                "nin" => ['required', 'numeric'],
                "otp" => ['required', 'numeric'],
                'phone' => ['required', 'numeric'],
            ]);

            if ($validation->fails()) {
                $ra = array("status" => 0, "message" => $validation->errors()->all()[0]);
                return response()->json($ra);
            }

            $getsetvalue = new Setting();

            $amount = $getsetvalue->getsettingskey('verifyme_nincharge');

            if ($getsetvalue->getsettingskey('enable_verifyme') == "1") {


                $compbal = $this->validatecompanybalance($amount, "vme");
                if ($compbal["status"] == false) {

                    $this->logInfo("validating company balance", $compbal);

                    return response()->json($compbal, 406);
                }

                if (Customer::where('nin', $request->nin)->first()) {
                    return response()->json(['status' => false, 'message' => 'This nin is attached to an account already']);
                }

                $glacctvas = GeneralLedger::select('id', 'status', 'account_balance')->where('gl_code', '10116963')->first();
                $glacctvmexpn = GeneralLedger::select('id', 'status', 'account_balance')->where('gl_code', '50536190')->first();


                $device = !empty($request->header('device_id')) ? $request->header('device_id') : $request->device_id;


                $checkphnmb = PhoneVerification::where(['phone' => $request->phone, 'otpcode' => $request->otp])->first();

                if ($checkphnmb) {

                    if ($checkphnmb->otp_expiration > Carbon::now()) { //check otp expiration time

                        $trxref = $this->generatetrnxref('ninr');

                        //  if($request->nin == "22222222222"){
                        //       $checkphnmb->otpcode = Str::random(4);
                        //         $checkphnmb->is_verify = 1;
                        //         $checkphnmb->save();

                        //             return \response()->json(['status' => true, 'message' => "BVN Verified Successfully", 'data' => [
                        //                 'first_name' => "test",
                        //                 'last_name' => "user",
                        //                 'dob' => "06-05-1900",
                        //                 'nin' => $request->nin,
                        //                 'phone' => $request->phone
                        //             ]]);
                        //         }



                        $response = $this->verifyNiN_VerifymeApi($request->nin);

                        //return $response;
                        $this->logInfo($response, "verifyme nin response log");

                        if ($response['status'] == true) {

                            $checkphnmb->otpcode = Str::random(4);
                            $checkphnmb->is_verify = 1;
                            $checkphnmb->save();

                            //companybal
                            $this->debitcreditCompanyBalance($amount, "debit", "vme");

                            if ($glacctvmexpn->status == '1') {
                                $this->gltransaction('withdrawal', $glacctvmexpn, $amount, null);
                                $this->create_saving_transaction_gl(null, $glacctvmexpn->id, null, $amount, 'debit', null, null, $trxref, 'nin request charge', 'approved', '');
                            }

                            if ($glacctvas->status == '1') {
                                $this->gltransaction('deposit', $glacctvas, $amount, null);
                                $this->create_saving_transaction_gl(null, $glacctvas->id, null, $amount, 'credit', null, $trxref, $this->generatetrnxref('bnv'), 'nin request charge', 'approved', '');
                            }

                            return response()->json(["status" => true, 'message' => $response['msg'], 'data' => [
                                'first_name' => $response['firstname'],
                                'last_name' => $response['lastname'],
                                'dob' => $response['dob'],
                                'nin' => $request->nin,
                                'phone' => $request->phone
                            ]]);
                        } else {
                            return response()->json(["status" => false, 'msg' => "Nin Verification Failed"]);
                        }
                    } else {
                        return response()->json(['status' => false, 'message' => 'OTP Expired...Resend OTP']);
                    }
                } else {

                    return response()->json(['status' => false, 'message' => 'Invalid OTP Supplied']);
                }
            } else {

                return response()->json(['status' => false, 'message' => 'Verifyme is not enabled']);
            }

            $lock->release();
        }
    }

    // public function verifyBVN(Request $request)
    // {

    //     $lock = Cache::lock('vribvn', 2);

    //     if ($lock->get()) {

    //         $ClientIp = !empty($request->header('ipaddr')) ? $request->header('ipaddr') : $request->ipaddr;

    //         $dvtyp = $request->deviceType == "web" ? "web- " . $ClientIp : "mobile- " . $ClientIp;

    //         $this->logInfo($request->all(), "Verify Bvn log api route " . $request->getClientIp() . " " . $dvtyp);

    //         $validation = Validator::make($request->all(), [
    //             "bvn" => ['required', 'numeric', 'digits:11'],
    //             "otp" => ['required', 'numeric'],
    //             'phone' => ['required', 'numeric']
    //         ]);

    //         if ($validation->fails()) {
    //             $ra = array("status" => 0, "message" => $validation->errors()->all()[0]);
    //             return response()->json($ra);
    //         }

    //         $getsetvalue = new Setting();

    //         $amount = $getsetvalue->getsettingskey('verifyme_bvncharge');

    //         if ($getsetvalue->getsettingskey('enable_verifyme') == "1") {


    //             $compbal = $this->validatecompanybalance($amount, "vme");
    //             if ($compbal["status"] == false) {

    //                 $this->logInfo("validating company balance", $compbal);

    //                 return response()->json($compbal, 406);
    //             }


    //             if (Customer::where('bvn', $request->bvn)->first()) {
    //                 return response()->json(['status' => false, 'message' => 'This bvn is attached to an account already']);
    //             }

    //             $glacctvas = GeneralLedger::select('id', 'status', 'account_balance')->where('gl_code', '10116963')->first();
    //             $glacctvmexpn = GeneralLedger::select('id', 'status', 'account_balance')->where('gl_code', '50536190')->first();


    //             $device = !empty($request->header('device_id')) ? $request->header('device_id') : $request->device_id;

    //             $checkphnmb = PhoneVerification::where(['phone' => $request->phone, 'otpcode' => $request->otp])->first();

    //             if ($checkphnmb) {

    //                 if ($checkphnmb->otp_expiration > Carbon::now()) { //check otp expiration time

    //                     $trxref = $this->generatetrnxref('bvnr');
    //                     //  if($request->bvn == "22222222222"){
    //                     //       $checkphnmb->otpcode = Str::random(4);
    //                     //         $checkphnmb->is_verify = 1;
    //                     //         $checkphnmb->save();

    //                     //             return \response()->json(['status' => true, 'message' => "BVN Verified Successfully", 'data' => [
    //                     //                 'first_name' => "test",
    //                     //                 'last_name' => "user",
    //                     //                 'dob' => "06-05-1900",
    //                     //                 'bvn' => $request->bvn,
    //                     //                 'phone' => $request->phone
    //                     //             ]]);
    //                     //         }

    //                     $verifymeBVN = $this->verifyBvNViaVerifymeApi($request->bvn);

    //                     //return $verifymeBVN;
    //                     if ($verifymeBVN['status'] == true) {

    //                         $checkphnmb->otpcode = Str::random(4);
    //                         $checkphnmb->is_verify = 1;
    //                         $checkphnmb->save();

    //                         //companybal
    //                         $this->debitcreditCompanyBalance($amount, "debit", "vme");

    //                         if ($glacctvmexpn->status == '1') {
    //                             $this->gltransaction('withdrawal', $glacctvmexpn, $amount, null);
    //                             $this->create_saving_transaction_gl(null, $glacctvmexpn->id, null, $amount, 'debit', null, null, $trxref, 'bvn request charge', 'approved', '');
    //                         }

    //                         if ($glacctvas->status == '1') {
    //                             $this->gltransaction('deposit', $glacctvas, $amount, null);
    //                             $this->create_saving_transaction_gl(null, $glacctvas->id, null, $amount, 'credit', null, $trxref, $this->generatetrnxref('bnv'), 'bvn request charge', 'approved', '');
    //                         }

    //                         return response()->json([
    //                             'status' => true,
    //                             'message' => "BVN Verified Successfully",
    //                             'data' => [
    //                                 'first_name' => $verifymeBVN["firstname"],
    //                                 'last_name' => $verifymeBVN["lastname"],
    //                                 'dob' => $verifymeBVN["dob"],
    //                                 'bvn' => $request->bvn,
    //                                 'phone' => $request->phone
    //                             ]
    //                         ]);
    //                     } else {
    //                         return response()->json(['status' => false, 'message' => "BVN Verification failed"], 406);
    //                     }
    //                 } else {
    //                     return response()->json(['status' => false, 'message' => 'OTP Expired...Resend OTP']);
    //                 }
    //             } else {

    //                 return response()->json(['status' => false, 'message' => 'invalid OTP supplied']);
    //             }
    //         } else {

    //             return response()->json(['status' => false, 'message' => 'Verifyme is not enable']);
    //         }

    //         $lock->release();
    //     }
    // }

    //verifyme bvn check
    // public  function verifyBvNViaVerifymeApi($bvn)
    // {

    //     $checktoken = DB::table('nip_access_tokens')->orderBy('id', 'DESC')->first();
    //     if (empty($checktoken)) {

    //         $token = $this->VerifymeAuthentication();
    //         $this->bearertoken = $token;
    //     } else {

    //         if ($checktoken->expiration_time > Carbon::now()) {
    //             $this->bearertoken = $checktoken->access_token;
    //         } else {
    //             $token = $this->VerifymeAuthentication();
    //             $this->bearertoken = $token;
    //         }
    //     }

    //     $response = Http::withHeaders([
    //         "accept" => "application/json",
    //         "content-type" => "application/json",
    //         "authorization" => "Bearer " . $this->bearertoken
    //     ])->post("https://api.qoreid.com/v1/ng/identities/bvn-basic/" . $bvn)->json();

    //     // return ["bv" => $bvn, "resp" => $response['status']['state'], "token" => $this->bearertoken];

    //     $this->logInfo($response, "verifyme bvn response log");

    //     if ($response['status']['state'] == "complete") {

    //         $bvnName = explode(" ", $response['bvn']['firstname']);

    //         $firstName = count($bvnName) > 2 ? $bvnName[1] : $bvnName[0];

    //         return [
    //             "status" => true,
    //             'msg' => "Bvn Verification Successfull",
    //             'firstname' => $firstName,
    //             'lastname' => $response['bvn']['lastname'],
    //             'dob' => $response['bvn']['birthdate']
    //         ];
    //     } else {
    //         return ["status" => false, 'msg' => "Bvn Verification Failed"];
    //     }
    // }

    //verifyme nin check
    public  function verifyNiN_VerifymeApi($nin)
    {


        $checktoken = DB::table('nip_access_tokens')->orderBy('id', 'DESC')->first();
        if (empty($checktoken)) {

            $token = $this->VerifymeAuthentication();
            $this->bearertoken = $token;
        } else {

            if ($checktoken->expiration_time > Carbon::now()) {
                $this->bearertoken = $checktoken->access_token;
            } else {
                $token = $this->VerifymeAuthentication();
                $this->bearertoken = $token;
            }
        }

        $response = Http::withHeaders([
            "accept" => "application/json",
            "content-type" => "application/json",
            "authorization" => "Bearer " . $this->bearertoken
        ])->post("https://api.qoreid.com/v1/ng/identities/nin/" . $nin)->json();

        //return ["respone" => $response['status']['state'], "token" => $this->bearertoken];
        $this->logInfo($response, "verifyme nin response log");

        if ($response['status']['state'] == "complete") {

            return [
                "status" => true,
                'msg' => "Nin Verification Successful",
                'firstname' => $response['nin']['firstname'],
                'lastname' => $response['nin']['lastname'],
                'dob' => $response['nin']['birthdate']
            ];
        } else {
            return ["status" => false, 'msg' => "Nin Verification Failed"];
        }
    }

    //verifyme login
    public  function VerifymeAuthentication()
    {

        $tstkey = env('APP_MODE') == 'test' ? env('TESTClientkey') : env('LIVEClientkey');
        $srctkey = env('APP_MODE') == 'test' ? env('TESTSecretkey') : env('LIVESecretkey');

        $duration = "7200";
        $exp = Carbon::now()->addSeconds($duration);

        $response = Http::withHeaders([
            "accept" => "text/plain",
            "content-type" => "application/json",
        ])->post("https://api.qoreid.com/token", [
            "clientId" => $tstkey,
            "secret" => $srctkey
        ]);

        DB::table('nip_access_tokens')->insert([
            "uuid" => Str::uuid(),
            "access_token" => $response["accessToken"],
            "expiration_time" => $exp
        ]);

        // return $response;
        $this->logInfo($response, "verifyme authentication response log");

        return $response["accessToken"];
    }
}//endclass
