<?php

namespace App\Exports;

use App\Models\Customer;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromView;

class CustomersBalanceExport implements FromView
{

    use Exportable;
    
     public $datavalue = null;
    public $filter;
    
    public function __construct($datavalue, $filter)
    {
    
        $this->filter = $filter;
        $this->datavalue = $datavalue;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function view(): View
    {
        $cust = Customer::select('id','first_name','last_name','business_name','acctno','accountofficer_id','phone')
                                ->when($this->filter == true, function($q){
                                    $q->where('acctno','like','%'.$this->datavalue.'%')
                                    ->orWhere('first_name','like','%'.$this->datavalue.'%')
                                    ->orWhere('last_name','like','%'.$this->datavalue.'%');
                                })
                            ->orderBy('id','DESC')->get();
        
        return view('deposit.exportbalance',[
            'customersbal' => $cust
        ]);
    }
}
