<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command('app:target-savings-command')->everyMinute()->withoutOverlapping();
        $schedule->command('app:target-savings-accrue-interest-command')
            ->dailyAt('03:00')
            ->timezone('Africa/Lagos')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/tgs_interest.log'));

        $schedule->command('app:monthly-savings-profit-command')
            ->monthlyOn(1, '01:00')
            ->timezone('Africa/Lagos');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
