<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Services\TargetSavingsService;

class TargetSavingsAccrueInterestCommand extends Command
{
    /**
     * The name and signature of the console command.
     * Keep YOUR signature:
     */
    protected $signature = 'app:target-savings-accrue-interest-command';

    /**
     * The console command description.
     */
    protected $description = 'Accrue daily interest for active Target Savings';

    /**
     * Execute the console command.
     */
    // public function handle(): int
    // {
    //     // Resolve the service (works across Laravel versions)
    //     /** @var TargetSavingsService $service */
    //     $service = app(TargetSavingsService::class);

    //     $res = $service->accrueDailyInterestCron();

    //     $msg = sprintf(
    //         'TargetSavings interest accrual: processed=%s, skipped=%s',
    //         $res['processed'] ?? 0,
    //         $res['skipped'] ?? 0
    //     );

    //     $this->info($msg);
    //     Log::info($msg, ['cmd' => $this->getName()]);

    //     return self::SUCCESS;
    // }

    public function handle(): int
    {
        /** @var TargetSavingsService $service */
        $service = app(TargetSavingsService::class);

        $res = $service->accrueDailyInterestCron();

        $msg = sprintf(
            'TargetSavings interest accrual: status=%s, message=%s, processed=%s, skipped=%s',
            $res['status'] ?? 'n/a',
            $res['message'] ?? 'n/a',
            $res['processed'] ?? 0,
            $res['skipped'] ?? 0
        );

        $this->info($msg);
        Log::info($msg, ['cmd' => $this->getName()]);

        return self::SUCCESS;
    }
}

