<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Services\SettingsService;   // ✅ Proper import

class MonthlySavingsProfitCommand extends Command
{
    /**
     * The command name/signature.
     */
    protected $signature = 'app:monthly-savings-profit-command';

    /**
     * The console command description.
     */
    protected $description = 'Run monthly savings profit calculation and credit eligible customers';

    /**
     * The service instance.
     */
    protected SettingsService $service;   // ✅ Define property

    /**
     * Constructor injection.
     */
    public function __construct(SettingsService $service)
    {
        parent::__construct();
        $this->service = $service;       // ✅ Assign injected service
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            // Run the monthly profit
            $paidCustomers = $this->service->applyMonthlySavingsProfit();

            $count = count($paidCustomers);

            $this->info("✅ Monthly savings profit executed successfully. Paid {$count} customer(s).");
            Log::info("MonthlySavingsProfitCommand executed", [
                'paid_customers_count' => $count,
            ]);

            return Command::SUCCESS;

        } catch (\Throwable $e) {
            $this->error("❌ Error running monthly profit: " . $e->getMessage());

            Log::error("MonthlySavingsProfitCommand Error", [
                'message' => $e->getMessage(),
                'trace'   => $e->getTraceAsString(),
            ]);

            return Command::FAILURE;
        }
    }
}
